#!/bin/bash
# example usage:
# bash sh/join_scores.sh --dirs=checkpoints/en2fr_iwslt16_wmt14_han/* --outdir=sh/results/en_fr/iwslt16_wmt14_big/shuffled_sent_scores

# Read script arguments and assign them to variables
for argument in "$@" 
do

    key=$(echo $argument | cut -f1 -d=)
    value=$(echo $argument | cut -f2 -d=)   
    if [[ $key == *"--"* ]]; then
        v="${key/--/}"
        declare $v="${value}" 
   fi
done

# vars: dirs, outdir
rm -rf $outdir
mkdir -p $outdir
scoring_script=sh/score_sys.sh

for subdir in $dirs; do
    # retrieve name for every subdirectory in the main directory
    subdir_name=$(echo "$subdir" | sed "s/.*\///")
    #
    if [ ! -f $subdir/logs/score.log ]; then
        echo "Calculating scores for $subdir_name"
        bash $scoring_script $subdir
    fi   
    #
    echo "Processing scores for $subdir_name"
    # Prepend kval to score file | remove second line (not a score line) | retain the BLEU4 score field only | remove trailing commas
    cat <(echo "$subdir_name") $subdir/logs/score.log | sed '2d' | cut -d " " -f 4 | sed 's/,$//g' > $outdir/$subdir_name.score.tmp
    cat <(echo "$subdir_name.sys") $subdir/logs/gen.out.sys > $outdir/$subdir_name.tmp
    if [ ! -f $outdir/*.src ]; then
        cat <(echo "src") $subdir/logs/gen.out.src > $outdir/src.tmp
        cat <(echo "ref") $subdir/logs/gen.out.ref > $outdir/ref.tmp
    fi
done

# paste src, ref, system outputs and their sentence scores in a unique file
if [ -f $outdir/result.csv ]; then
    rm $outdir/result.csv
fi
paste $outdir/* > $outdir/result.csv
# delete tmp files but the reference
tail -n +2 $outdir/ref.tmp > $outdir/gen.out.ref
rm $outdir/*.tmp
# print head to check result
# head $outdir/result.csv