/*
 * Decompiled with CFR 0.152.
 */
package text_categorization;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextCategorizerFingerprint {
    private String category;
    private HashMap<String, Integer> sorted_entries;
    private HashMap<String, Integer> categoryDistances;
    private Pattern pattern;

    public TextCategorizerFingerprint() {
        this.category = "unknown";
        this.sorted_entries = new HashMap();
        this.categoryDistances = new HashMap();
        this.pattern = Pattern.compile("^_?[^0-9\\?!\\-_/]*_?$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextCategorizerFingerprint(String file_path, String cat) {
        block8: {
            this.category = "unknown";
            this.sorted_entries = new HashMap();
            this.categoryDistances = new HashMap();
            this.pattern = Pattern.compile("^_?[^0-9\\?!\\-_/]*_?$");
            try {
                BufferedReader reader = new BufferedReader(new FileReader(new File(file_path)));
                this.sorted_entries.clear();
                try {
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        String[] line_arr = line.split("\\s+");
                        if (line_arr.length <= 0) continue;
                        if (line_arr.length != 2) {
                            throw new Exception("Malformed TextCategorizer configuration file.\n\tMust contain one fingerprint file path per line.");
                        }
                        this.sorted_entries.put(line_arr[0], new Integer(line_arr[1]));
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    this.category = cat;
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block8;
                e.printStackTrace(System.err);
            }
        }
    }

    public void save() {
        File file = new File(this.getCategory() + ".lm");
        try {
            if (file.createNewFile()) {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(this.toString().getBytes());
                fos.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace(System.err);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    public String getCategory() {
        return this.category;
    }

    public HashMap getSorted_entries() {
        return this.sorted_entries;
    }

    public void create(File file) {
        char[] data = new char[1024];
        String s = "";
        try {
            int read;
            FileReader fr = new FileReader(file);
            while ((read = fr.read(data)) != -1) {
                s = s + new String(data, 0, read);
            }
            fr.close();
            this.create(s);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    public void create(String text) {
        HashMap entries = new HashMap();
        entries = this.computeNGrams(1, 5, text);
        if (entries.containsKey("_")) {
            int blanksScore = (Integer)entries.remove("_");
            entries.put("_", blanksScore / 2);
        }
        ArrayList sorted_keys = new ArrayList(entries.keySet());
        Collections.sort(sorted_keys, new NGramMapComparator(entries));
        this.sorted_entries.clear();
        int n = sorted_keys.size();
        for (int i = 0; i < n; ++i) {
            this.sorted_entries.put((String)sorted_keys.get(i), i + 1);
        }
    }

    private HashMap computeNGrams(int ngramMinOrder, int ngramMaxOrder, String text) {
        text = text.replaceAll("[.,]", "");
        String[] tokens = text.split("\\s+");
        HashMap<String, Integer> entries = new HashMap<String, Integer>();
        for (int order = ngramMinOrder; order <= ngramMaxOrder; ++order) {
            for (String token : tokens) {
                token = "_" + token + "_";
                for (int i = 0; i < token.length() - order + 1; ++i) {
                    String ngram = token.substring(i, i + order);
                    Matcher matcher = this.pattern.matcher(ngram);
                    if (!matcher.find()) continue;
                    if (!entries.containsKey(ngram)) {
                        entries.put(ngram, 1);
                        continue;
                    }
                    int score = (Integer)entries.remove(ngram);
                    entries.put(ngram, ++score);
                }
            }
        }
        return entries;
    }

    public Map<String, Integer> categorize(Collection<TextCategorizerFingerprint> categories) {
        int minDistance = Integer.MAX_VALUE;
        for (TextCategorizerFingerprint fp : categories) {
            int distance = this.getDistance(fp.getSorted_entries());
            this.getCategoryDistances().put(fp.getCategory(), distance);
            if (distance >= minDistance) continue;
            minDistance = distance;
            this.category = fp.getCategory();
        }
        return this.getCategoryDistances();
    }

    public Map<String, Integer> getCategoryDistances() {
        return this.categoryDistances;
    }

    private int getDistance(HashMap<String, Integer> category) {
        int distance = 0;
        int count = 0;
        for (Map.Entry<String, Integer> entry : this.sorted_entries.entrySet()) {
            String ngram = entry.getKey();
            if (++count > 400) break;
            if (!category.containsKey(ngram)) {
                distance += category.size();
                continue;
            }
            distance += Math.abs(this.sorted_entries.get(ngram) - category.get(ngram));
        }
        return distance;
    }

    private class NGramMapComparator
    implements Comparator {
        private Map _data = null;

        public NGramMapComparator(Map data) {
            this._data = data;
        }

        public int compare(Object o1, Object o2) {
            String k1 = (String)o1;
            String k2 = (String)o2;
            Integer v1 = (Integer)this._data.get(k1);
            Integer v2 = (Integer)this._data.get(k2);
            int diff = v2 - v1;
            if (diff == 0 && (diff = k2.length() - k1.length()) == 0) {
                diff = k1.compareTo(k2);
            }
            return diff;
        }
    }
}

