#!/usr/bin/env bash

OUT_DIR=results_attend_model

mkdir -p ${OUT_DIR}

args_add="--do_train --predict_type=dummy"
step="train"

# run_dst_attend3 使用 不变 lr
nohup python3 run_dst_attend2.py \
        --model_type="bert" \
        --model_name_or_path="../pretrained_models/bert" \
        --do_lower_case \
        --learning_rate=1e-4 \
        --num_train_epochs=36 \
        --max_seq_length=256 \
        --per_gpu_train_batch_size=36 \
        --per_gpu_eval_batch_size=1 \
        --output_dir=${OUT_DIR} \
        --save_epochs=1 \
        --logging_steps=50 \
        --warmup_proportion=0.1 \
        --gradient_accumulation_steps=1 \
        --eval_all_checkpoints \
        --adam_epsilon=1e-6 \
        --label_value_repetitions \
        --swap_utterances \
        --append_history \
        --use_history_labels \
        --delexicalize_sys_utts \
        --class_aux_feats_inform \
        --class_aux_feats_ds \
        --attend_file="attend/curriculum_data_mix" \
        ${args_add} \
        > ${OUT_DIR}/attend.log 2>&1 &