"""
This script is used to split the squad like data into two halves.
"""
import os
import json
import sys


if __name__ == "__main__":
    biases = ["emptyqst", "wh-word", "lexical"]
    folder = sys.argv[1]

    for bias in biases:
        print(bias)
        f_out1 = open(os.path.join(folder, "train-bart-"+bias+"-part1.json"), "w")
        f_out2 = open(os.path.join(folder, "train-bart-"+bias+"-part2.json"), "w")
        with open(os.path.join(folder, "train-bart-"+bias+".json")) as f_in:
            data = json.load(f_in)["data"]
            data1 = {"data": data[:int(len(data) / 2)]}
            data2 = {"data": data[int(len(data) / 2):]}
        json.dump(data1, f_out1, indent=4)
        json.dump(data2, f_out2, indent=4)
        f_out1.close()
        f_out2.close()
