for arg in "$@"
  do
    case $arg in
      -i|--inputfile)
      INPUTFILE="$2"
      shift
      shift
      ;;
      -o|--outputfile)
      OUTPUTFILE="$2"
      shift
      shift
      ;;
    esac
  done

echo "input file   = ${INPUTFILE}"
echo "output file  = ${OUTPUTFILE}"

start_time=`date +%s`

alias python=python3

git clone -b dev/zheng/codalab --single-branch https://github.com/stevezheng23/transformers.git

cd transformers
cp examples/run_quac.py ./
cp examples/utils_quac.py ./
cp examples/utils_quac_evaluate.py ./

mkdir data
mkdir data/quac
cp ../${INPUTFILE} data/quac/dev-v0.2.json

mkdir output
mkdir output/quac
wget -P output/quac https://storage.googleapis.com/mrc_data/quac/roberta-large-quac-20191101.zip
unzip output/quac/roberta-large-quac-20191101.zip -d output/quac/
mv output/quac/roberta-large-quac-20191101 output/quac/roberta-large-quac
rm output/quac/roberta-large-quac-20191101.zip

CUDA_VISIBLE_DEVICES=0 python run_quac.py \
--model_type=roberta \
--model_name_or_path=output/quac/roberta-large-quac \
--do_eval \
--version_2_with_negative \
--train_file=data/quac/train-v0.2.json \
--predict_file=data/quac/dev-v0.2.json \
--learning_rate=1.5e-5 \
--num_train_epochs=2 \
--max_seq_length=512 \
--max_query_length=64 \
--max_answer_length=30 \
--doc_stride=128 \
--output_dir=output/quac/roberta-large-quac \
--per_gpu_eval_batch_size=12 \
--per_gpu_train_batch_size=12 \
--seed=1000 \
--warmup_steps=500 \
--save_steps=1000 \
--weight_decay=0.01 \
--null_score_threshold=0.5

cp output/quac/roberta-large-quac/predictions_.json ../${OUTPUTFILE}

cd ..
rm -r transformers

end_time=`date +%s`
echo execution time was `expr $end_time - $start_time` s.
