import argparse
import os

parser = argparse.ArgumentParser()
parser.add_argument('dir')
parser.add_argument('--start', type=int, default=0)
parser.add_argument('--stop', type=int, default=4)

args = parser.parse_args()

gab_dev, gab_test, ws_test, nyt_test = [], [], [], []
gab_dev_acc, gab_test_acc = [], []

def get_result(lines, key):
    dic = {}
    for line in lines:
        items = line.split('=')
        v = items[1].strip()
        # try:
        #     v = float(v)
        # except Exception:
        #     pass
        dic[items[0].strip()] = v
    return dic[key]

for seed in range(args.start, args.stop + 1):
    gd = open('runs/{}_seed_{}/eval_results_0_dev_gab.txt'.format(args.dir, seed)).readlines()
    gt = open('runs/{}_seed_{}/eval_results_0_test_gab.txt'.format(args.dir, seed)).readlines()
    ws = open('runs/{}_seed_{}/eval_results_0_test_ws.txt'.format(args.dir, seed)).readlines()
    nyt = open('runs/{}_seed_{}/eval_results_0_test_nyt.txt'.format(args.dir, seed)).readlines()
    gab_dev.append(get_result(gd, 'f1'))
    gab_dev_acc.append(get_result(gd, 'acc'))
    gab_test.append(get_result(gt, 'f1'))
    gab_test_acc.append(get_result(gt, 'acc'))
    ws_test.append(get_result(ws, 'f1'))
    nyt_test.append(get_result(nyt, 'acc'))

def print_line(l):
    print('\t'.join(l))

def print_lines(ls):
    for x in zip(*ls):
        print('\t'.join(x))
#
# print_line(gab_dev)
# print_line(gab_dev_acc)
# print_line(gab_test)
# print_line(gab_test_acc)
# print_line(ws_test)
# print_line(nyt_test)

print_lines([gab_dev, gab_test, gab_dev_acc, gab_test_acc, ws_test, nyt_test])