function candoit = canGetSubgradient(problem)
% Checks whether a subgradient can be computed for a problem structure.
% 
% function candoit = canGetSubgradient(problem)
%
% Returns true if a subgradient of the cost function can be computed given
% the problem description, false otherwise.
%
% See also: canGetGradient

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, July 20, 2017.
% Contributors: 
% Change log: 

    candoit = isfield(problem, 'subgrad') || canGetGradient(problem);
    
end
