/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Tag;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TrainOptions;
import edu.stanford.nlp.parser.lexparser.UnknownWordModel;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import java.util.Map;
import java.util.Set;

public class BaseUnknownWordModel
implements UnknownWordModel {
    private static final long serialVersionUID = 6355171148751673822L;
    protected static final boolean VERBOSE = false;
    protected boolean useFirst;
    private final boolean useEnd;
    protected boolean useGT;
    private final boolean useFirstCap;
    private int endLength = 2;
    protected final int unknownLevel;
    protected static final String unknown = "UNK";
    protected static final int nullWord = -1;
    protected static final short nullTag = -1;
    protected static final IntTaggedWord NULL_ITW = new IntTaggedWord(-1, -1);
    protected final TrainOptions trainOptions;
    protected final Index<String> wordIndex;
    protected final Index<String> tagIndex;
    protected final ClassicCounter<IntTaggedWord> unSeenCounter;
    protected final Map<Label, ClassicCounter<String>> tagHash;
    private final Set<String> seenEnd;
    final Map<String, Float> unknownGT;
    private final Lexicon lex;

    public BaseUnknownWordModel(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex, ClassicCounter<IntTaggedWord> unSeenCounter, Map<Label, ClassicCounter<String>> tagHash, Map<String, Float> unknownGT, Set<String> seenEnd) {
        this.endLength = op.lexOptions.unknownSuffixSize;
        this.useEnd = op.lexOptions.unknownSuffixSize > 0 && op.lexOptions.useUnknownWordSignatures > 0;
        this.useFirstCap = op.lexOptions.useUnknownWordSignatures > 0;
        this.useGT = op.lexOptions.useUnknownWordSignatures == 0;
        this.useFirst = false;
        this.lex = lex;
        this.trainOptions = op.trainOptions;
        this.wordIndex = wordIndex;
        this.tagIndex = tagIndex;
        this.unSeenCounter = unSeenCounter;
        this.tagHash = tagHash;
        this.seenEnd = seenEnd;
        this.unknownGT = unknownGT;
        this.unknownLevel = op.lexOptions.useUnknownWordSignatures;
    }

    public BaseUnknownWordModel(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex) {
        this(op, lex, wordIndex, tagIndex, new ClassicCounter<IntTaggedWord>(), Generics.newHashMap(), Generics.newHashMap(), Generics.newHashSet());
    }

    @Override
    public float score(IntTaggedWord itw, int loc, double c_Tseen, double total, double smooth, String word) {
        return this.score(itw, word);
    }

    public float score(IntTaggedWord itw, String word) {
        float logProb;
        String tagStr = itw.tagString(this.tagIndex);
        Tag tag = new Tag(tagStr);
        if (this.useEnd || this.useFirst || this.useFirstCap) {
            String end = this.getSignature(word, -1);
            if (this.useGT && !this.seenEnd.contains(end)) {
                logProb = this.scoreGT(tagStr);
            } else {
                ClassicCounter<String> wordProbs;
                if (!this.seenEnd.contains(end)) {
                    end = unknown;
                }
                if ((wordProbs = this.tagHash.get(tag)) == null) {
                    System.err.println("Warning: proposed tag is unseen in training data:\t" + tagStr);
                    logProb = Float.NEGATIVE_INFINITY;
                } else {
                    logProb = wordProbs.keySet().contains(end) ? (float)wordProbs.getCount(end) : (float)wordProbs.getCount(unknown);
                }
            }
        } else if (this.useGT) {
            logProb = this.scoreGT(tagStr);
        } else {
            System.err.println("Warning: no unknown word model in place!\nGiving the combination " + word + ' ' + tagStr + " zero probability.");
            logProb = Float.NEGATIVE_INFINITY;
        }
        return logProb;
    }

    @Override
    public double scoreProbTagGivenWordSignature(IntTaggedWord iTW, int loc, double smooth, String word) {
        throw new UnsupportedOperationException();
    }

    protected float scoreGT(String tag) {
        if (this.unknownGT.containsKey(tag)) {
            return this.unknownGT.get(tag).floatValue();
        }
        return Float.NEGATIVE_INFINITY;
    }

    @Override
    public String getSignature(String word, int loc) {
        StringBuilder subStr = new StringBuilder("UNK-");
        int n = word.length() - 1;
        char first = word.charAt(0);
        if (this.useFirstCap) {
            if (Character.isUpperCase(first) || Character.isTitleCase(first)) {
                subStr.append('C');
            } else {
                subStr.append('c');
            }
        }
        if (this.useFirst) {
            subStr.append(first);
        }
        if (this.useEnd) {
            subStr.append(word.substring(n - this.endLength > 0 ? n - this.endLength : 0, n));
        }
        return subStr.toString();
    }

    @Override
    public int getSignatureIndex(int wordIndex, int sentencePosition, String word) {
        return 0;
    }

    @Override
    public Lexicon getLexicon() {
        return this.lex;
    }

    @Override
    public int getUnknownLevel() {
        return this.unknownLevel;
    }

    @Override
    public void addTagging(boolean seen, IntTaggedWord itw, double count) {
        if (seen) {
            System.err.println("UWM.addTagging: Shouldn't call with seen word!");
        } else {
            this.unSeenCounter.incrementCount(itw, count);
        }
    }

    @Override
    public Counter<IntTaggedWord> unSeenCounter() {
        return this.unSeenCounter;
    }
}

