/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.syntax.CCGNode;
import LinguaView.syntax.CategoryObject;
import fig.basic.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ardverk.collection.PatriciaTrie;

public class CCGTerminalNode
extends CCGNode {
    String mod_POS;
    String orig_POS;
    String word;
    String predArgCat;
    String markup;
    private static PatriciaTrie<String, String> _interpretation = null;

    public static void setInterpret(PatriciaTrie<String, String> interpretation) {
        _interpretation = interpretation;
    }

    public CCGTerminalNode(String label, int index) {
        label = label.substring(3, label.length() - 1);
        String[] labelSplit = label.split("\\s+");
        this.mod_POS = labelSplit[1];
        this.orig_POS = labelSplit[2];
        this.word = labelSplit[3];
        this.predArgCat = labelSplit[4];
        if (labelSplit.length > 5) {
            this.additionalInfo = labelSplit[5];
        }
        if (_interpretation != null) {
            CategoryObject temp = CategoryObject.fromPlainCat(labelSplit[0]);
            this.markup = (String)_interpretation.get(temp.toString());
            if (this.markup != null) {
                this.cat = CategoryObject.fromCACCats(this.markup);
                this.cat.head(index);
            } else {
                this.cat = CategoryObject.fromPredArgCat(labelSplit[4]);
                this.cat.head(index);
            }
        } else {
            this.cat = CategoryObject.fromPredArgCat(labelSplit[4]);
            this.cat.head(index);
        }
        this.index(index);
    }

    public CCGTerminalNode(String word, String POS, String markup, String additionalInfro, int index) {
        this.word = word;
        this.orig_POS = POS;
        this.mod_POS = POS;
        this.predArgCat = markup;
        this.additionalInfo = additionalInfro;
        this.cat = CategoryObject.fromCACCats(markup);
        this.index(index);
        this.cat.head(index);
        this.slots = new Set[1][this.cat._slots.length];
        this.newlyFilledSlots = Collections.emptyMap();
        this.unfilledSlots = new HashMap();
        int i = 0;
        while (i < this.slots[0].length) {
            Pair<Integer, Integer> p = new Pair<Integer, Integer>(index, i);
            CategoryObject.CoindexedObject head = this.cat._slots[i]._headObj;
            HashSet<Pair<Integer, Integer>> sets = (HashSet<Pair<Integer, Integer>>)this.unfilledSlots.get(head);
            if (sets == null) {
                sets = new HashSet<Pair<Integer, Integer>>();
                this.unfilledSlots.put(head, sets);
            }
            sets.add(p);
            ++i;
        }
    }

    public String word() {
        return this.word;
    }

    public String modPOS() {
        return this.mod_POS;
    }

    private void index(int i) {
        this.start = i;
        this.end = i;
    }

    public Set<Integer> headOfSlot(int i) {
        return this.cat._slots[i].head();
    }

    public int index() {
        return this.start;
    }

    public int numOfSlots() {
        return this.cat.depth();
    }

    @Override
    public String toString() {
        return "(<L " + this.cat + " " + this.mod_POS + " " + this.orig_POS + " " + this.word + " " + this.predArgCat + ">)";
    }

    @Override
    public String toStringWithAdditionalField() {
        StringBuffer sb = new StringBuffer("(<L " + this.cat + " " + this.mod_POS + " " + this.orig_POS + " " + this.word + " " + this.predArgCat);
        if (this.additionalInfo != null) {
            sb.append(" " + this.additionalInfo);
        }
        sb.append(">)");
        return sb.toString();
    }

    @Override
    public String toIndentedTreeString(int depth) {
        return this.toTreeString();
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public String toTreeString() {
        String str = "(" + this.cat + " " + this.word + ")";
        return str;
    }

    public boolean isPunctuation() {
        return this.word.matches("[.,:;'`?!()]+");
    }

    @Override
    public CCGTerminalNode headTerm() {
        return this;
    }

    public static void main(String[] args) {
        CCGTerminalNode c = new CCGTerminalNode("<L (S[dcl]\\NP)/S[dcl] VBZ VBZ says (S[dcl]\\NP_187)/S[dcl]_188>", 5);
        System.out.println(c);
        CCGTerminalNode c1 = new CCGTerminalNode("eat", "VP", "S/NP_1", "_", 5);
        System.out.println(c1);
    }
}

