// syntaxsum.h
//
// by William M. Darling (c) 2010
//
// header file for syntaxsum.cpp

#ifndef SYNTAXSUM_H
#define SYNTAXSUM_H

#include <string>
#include <vector>
#include <iostream>

using namespace std;

class syntaxsum {
	
public:
	
	double beta;
	double gamma;
	
	syntaxsum();
	~syntaxsum();
	
	void run(int iterations);
	void setup(double b, double g, const char *WS, const char *DS, int nt, int ns, int dps);
	void write();

private:
	
	vector<int> w;		// word stream
	vector<int> d;		// doc stream
	
	vector<int> z;		// word topic allocations
	vector<int> c;		// word syntax class allocations
		
	vector<int> nz;		// total allocations to each topic
	vector<int> nc;		// total allocations to each syntax class
	
	vector<int> nwc;	// class-word 'matrix'
	vector<int> nwz;	// topic-word 'matrix'
	
	int N;				// num tokens
	int W;				// num words
	int D;				// num documents
	int T;				// num topics
	int S;				// num states
	
	int docspds;		// num documents per document set
	
	// methods
	void gibbs(int iterations);
};



#endif	// SYNTAXSUM_H
