/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TLongHashSet;
import gnu.trove.TLongIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class TLongHashSetDecorator
extends AbstractSet
implements Set {
    protected final TLongHashSet _set;

    public TLongHashSetDecorator(TLongHashSet set) {
        this._set = set;
    }

    public boolean add(Object value) {
        return this._set.add(this.unwrap(value));
    }

    public boolean equals(Object other) {
        if (this._set.equals(other)) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (that.size() != this._set.size()) {
                return false;
            }
            Iterator it = that.iterator();
            int i = that.size();
            while (i-- > 0) {
                Object val = it.next();
                if (val instanceof Long) {
                    long v = this.unwrap(val);
                    if (this._set.contains(v)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this._set.clear();
    }

    public boolean remove(Object value) {
        return this._set.remove(this.unwrap(value));
    }

    public Iterator iterator() {
        return new Iterator(){
            private final TLongIterator it;
            {
                this.it = TLongHashSetDecorator.this._set.iterator();
            }

            public Object next() {
                return TLongHashSetDecorator.this.wrap(this.it.next());
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public void remove() {
                this.it.remove();
            }
        };
    }

    public int size() {
        return this._set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Long wrap(long k) {
        return new Long(k);
    }

    protected long unwrap(Object value) {
        return (Long)value;
    }
}

