#!/bin/bash
#before run this script, you must have cleaned dataset.
#clean up the burst directory
#$1 is language (en/ch), $2 is the year (2002|2003|...|2010)
#for example, to construct the English stream in 2002, you should run this script like this: bash build_binet.sh en 2002
mkdir $1_burst
rm $1_burst/*
echo Detect burst...
python day_burst_detector.py $1_stream $2
echo Analyze df,idf
python idf.py $1 $2
echo burstterm...
python distinctterm.py $1
echo Kleinberg burst
python KleinburgAlg.py $1 $2
echo combine kleinberg
python klcombine.py $1
echo index burst features
python feature_index.py $1
echo time burst feature
python time_burst.py $1 $2
echo construct graph
python graph_construct.py $1 $2
echo construct ad_table
python adjacent_table.py $1
