/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.syntaxgraph.feature;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.AddressFunction;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.value.FeatureValue;
import org.maltparser.core.feature.value.SingleFeatureValue;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.SymbolTableHandler;
import org.maltparser.core.syntaxgraph.SyntaxGraphException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistsFeature
implements FeatureFunction {
    protected AddressFunction addressFunction;
    protected SymbolTableHandler tableHandler;
    protected SymbolTable table;
    protected SingleFeatureValue featureValue = new SingleFeatureValue(this);

    public ExistsFeature(SymbolTableHandler tableHandler) throws MaltChainedException {
        this.setTableHandler(tableHandler);
    }

    @Override
    public void initialize(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 1) {
            throw new SyntaxGraphException("Could not initialize ExistsFeature: number of arguments are not correct. ");
        }
        if (!(arguments[0] instanceof AddressFunction)) {
            throw new SyntaxGraphException("Could not initialize ExistsFeature: the first argument is not an address function. ");
        }
        this.setAddressFunction((AddressFunction)arguments[0]);
        this.setSymbolTable(this.tableHandler.addSymbolTable("EXISTS", 1, "one"));
        this.table.addSymbol("TRUE");
        this.table.addSymbol("FALSE");
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class[] paramTypes = new Class[]{AddressFunction.class};
        return paramTypes;
    }

    @Override
    public String getSymbol(int code) throws MaltChainedException {
        return this.table.getSymbolCodeToString(code);
    }

    @Override
    public int getCode(String symbol) throws MaltChainedException {
        return this.table.getSymbolStringToCode(symbol);
    }

    @Override
    public void updateCardinality() {
        this.featureValue.setCardinality(this.table.getValueCounter());
    }

    @Override
    public void update() throws MaltChainedException {
        if (this.addressFunction.getAddressValue().getAddress() != null) {
            this.featureValue.setCode(this.table.getSymbolStringToCode("TRUE"));
            this.featureValue.setSymbol("TRUE");
            this.featureValue.setKnown(true);
            this.featureValue.setNullValue(false);
        } else {
            this.featureValue.setCode(this.table.getSymbolStringToCode("FALSE"));
            this.featureValue.setSymbol("FALSE");
            this.featureValue.setKnown(true);
            this.featureValue.setNullValue(false);
        }
    }

    @Override
    public FeatureValue getFeatureValue() {
        return this.featureValue;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.table;
    }

    public AddressFunction getAddressFunction() {
        return this.addressFunction;
    }

    public void setAddressFunction(AddressFunction addressFunction) {
        this.addressFunction = addressFunction;
    }

    public SymbolTableHandler getTableHandler() {
        return this.tableHandler;
    }

    public void setTableHandler(SymbolTableHandler tableHandler) {
        this.tableHandler = tableHandler;
    }

    public void setSymbolTable(SymbolTable table) {
        this.table = table;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public int hashCode() {
        return 217 + (null == this.toString() ? 0 : this.toString().hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Exists(");
        sb.append(this.addressFunction.toString());
        sb.append(')');
        return sb.toString();
    }
}

