/*
 * Decompiled with CFR 0.152.
 */
package segmenter;

import com.aliasi.tokenizer.LowerCaseTokenizerFactory;
import com.aliasi.tokenizer.PorterStemmerTokenizerFactory;
import com.aliasi.tokenizer.RegExFilteredTokenizerFactory;
import com.aliasi.tokenizer.RegExTokenizerFactory;
import com.aliasi.tokenizer.StopTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import commandln.BoolParam;
import commandln.CommandLineParser;
import commandln.DirectoryParam;
import commandln.DoubleArrayParam;
import commandln.DoubleParam;
import commandln.IParam;
import commandln.IfGroup;
import commandln.IntArrayParam;
import commandln.IntParam;
import commandln.OrGroup;
import commandln.ParamGroup;
import commandln.StringArrayParam;
import commandln.StringParam;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import segmenter.AbstractAPSegmenterDP;
import segmenter.AffinityPropagationSegmenterDense;
import segmenter.AffinityPropagationSegmenterSparse;
import segmenter.IDataSource;
import segmenter.LinearEvaluator;
import segmenter.SimpleFileDataSource;
import segmenter.TextFileIO;
import similarity.CosineSimComputer;
import similarity.DfDictionary;
import similarity.Document;
import similarity.ISimComputer;
import similarity.TokenDictionary;

public class RunSegmenter {
    static boolean lowerCase = true;
    static boolean useStemmer = true;
    static boolean removeStopWords = true;
    static File stopWordsFile = new File("./STOPWORD.list");
    String segmPattern = "[=]+";

    public AbstractAPSegmenterDP CreateConfiguredSegmenter(IDataSource[] iDataSourceArray, IDataSource iDataSource, boolean bl, Integer n, TokenizerFactory tokenizerFactory, boolean bl2, int n2, boolean bl3, Double d, Integer n3, double d2, double d3, File file) {
        Object object;
        int n4;
        DfDictionary dfDictionary;
        if (!bl) {
            dfDictionary = new DfDictionary(iDataSourceArray, tokenizerFactory, iDataSourceArray.length);
            n4 = iDataSourceArray.length;
            try {
                dfDictionary.ProcessCorpus();
            }
            catch (Exception exception) {
                System.out.println("Exception in CreateConfiguredSegmenter when processing dfDict globally:");
                exception.printStackTrace();
            }
        } else {
            n4 = n;
            object = new IDataSource[]{iDataSource};
            dfDictionary = new DfDictionary((IDataSource[])object, tokenizerFactory, n);
            try {
                dfDictionary.ProcessCorpus();
            }
            catch (Exception exception) {
                System.out.println("Exception in CreateConfiguredSegmenter when processing dfDict with segments:");
                exception.printStackTrace();
            }
        }
        dfDictionary.ForgetCorpus();
        try {
            object = new TokenDictionary(iDataSource, tokenizerFactory);
            ((TokenDictionary)object).ProcessText();
            Document document = new Document((TokenDictionary)object, n4, iDataSource);
            document.setDocFreqs(dfDictionary);
            document.Init();
            document.ComputeTfIdf();
            if (bl3) {
                document.SmoothSentCounts(n3, d);
            }
            document.ApplyTfIdfWeighting();
            CosineSimComputer cosineSimComputer = new CosineSimComputer();
            cosineSimComputer.Init(iDataSource);
            cosineSimComputer.SetUp((TokenDictionary)object, n2, bl2, file);
            cosineSimComputer.SetSentenceVectors(document.getSentVectors());
            cosineSimComputer.ComputeSimilarities();
            document = null;
            cosineSimComputer.ForgetSentVectors();
            AbstractAPSegmenterDP abstractAPSegmenterDP = this.CreateAffinityPropagationSegmenter(cosineSimComputer, d2, d3, bl2);
            return abstractAPSegmenterDP;
        }
        catch (Exception exception) {
            System.out.println("Exception processing " + iDataSource.GetName());
            exception.printStackTrace();
            return null;
        }
    }

    public void Run(String string, String string2, String string3, double d, double d2, boolean bl, Integer n, TokenizerFactory tokenizerFactory, boolean bl2, Integer n2, Double d3, boolean bl3, Double d4, Integer n3, String[] stringArray, String[] stringArray2) {
        Object object;
        int n4;
        File[] fileArray;
        File file = new File(string);
        File file2 = new File(string2);
        File file3 = new File(file2, string3);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        TokenizerFactory tokenizerFactory2 = this.CreateTokenizerFactory();
        IDataSource[] iDataSourceArray = new IDataSource[]{};
        if (!bl) {
            fileArray = file.listFiles(new SegFileFilter(stringArray2));
            iDataSourceArray = new IDataSource[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                File file4 = fileArray[i];
                try {
                    iDataSourceArray[i] = new SimpleFileDataSource(file4, this.segmPattern);
                    iDataSourceArray[i].Init(1);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        fileArray = file.listFiles(new SegFileFilter(stringArray));
        ArrayList<EvalResult> arrayList = new ArrayList<EvalResult>();
        for (n4 = 0; n4 < fileArray.length; ++n4) {
            File file5 = fileArray[n4];
            try {
                int n5;
                Date date = new Date();
                System.out.println("\n\nprocessing " + file5.getAbsolutePath());
                object = new SimpleFileDataSource(file5, this.segmPattern);
                object.Init(1);
                if (n2 != null) {
                    n5 = n2;
                } else if (d3 != null) {
                    if (d3 >= 1.0) {
                        System.out.println("windowRation > 1. Setting it to default value 0.5");
                        d3 = 0.5;
                    }
                    n5 = (int)Math.round(d3 * (double)object.GetNumChunks());
                } else {
                    throw new Exception("Either simWindowSize or simWindowRation has to be defined");
                }
                if (n5 > 400) {
                    System.out.println("WARNING: large window for computing similarity " + String.valueOf(n5) + " Convergence may take a while.");
                }
                if (n5 >= object.GetNumChunks()) {
                    System.out.println("window too large (" + String.valueOf(n5) + ") when numChunks " + String.valueOf(object.GetNumChunks()));
                    n5 = object.GetNumChunks() - 1;
                    System.out.println("New win size" + String.valueOf(n5));
                }
                if (bl) {
                    iDataSourceArray = new IDataSource[]{object};
                }
                AbstractAPSegmenterDP abstractAPSegmenterDP = this.CreateConfiguredSegmenter(iDataSourceArray, (IDataSource)object, bl, n, tokenizerFactory2, bl2, n5, bl3, d4, n3, d, d2, file2);
                abstractAPSegmenterDP.Run();
                TreeMap<Integer, TreeSet<Integer>> treeMap = abstractAPSegmenterDP.GetAssignments();
                treeMap = abstractAPSegmenterDP.GetNonConflictingAssignments();
                Integer[] integerArray = this.GetHypoBreaks(treeMap);
                LinearEvaluator linearEvaluator = new LinearEvaluator();
                linearEvaluator.Init((IDataSource)object, integerArray);
                String string4 = linearEvaluator.evaluate();
                System.out.println(string4);
                double d8 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.REGULAR);
                double d9 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.FP);
                double d10 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.FN);
                double d11 = 0.0;
                if (n2 != null) {
                    d11 = n2.intValue();
                } else if (d3 != null) {
                    d11 = d3;
                }
                EvalResult evalResult = new EvalResult(d2, d, d8, d11, object.GetReferenceSegmentBreaks().length, integerArray.length);
                evalResult.SetFPFN(d9, d10);
                arrayList.add(evalResult);
                d5 += d8;
                d6 += d9;
                d7 += d10;
                object.Output(new File(string2 + "/" + file5.getName() + ".seg"), integerArray);
                Date date2 = new Date();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Exception in RunAPSeg");
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
        n4 = fileArray.length;
        double d12 = this.ComputeStdDevWinDiff(arrayList);
        object = "WinDiffRegular: " + String.valueOf(d5 / (double)n4) + "\n";
        object = (String)object + "WinDiffFP: " + String.valueOf(d6 / (double)n4) + "\n";
        object = (String)object + "WinDiffFN: " + String.valueOf(d7 / (double)n4) + "\n";
        object = (String)object + "WinDiff std dev: " + String.valueOf(d12) + "\n";
        TextFileIO.OutputFile(file3, (String)object);
    }

    public void CompareSegmentations(File file, File file2, File file3, String[] stringArray) {
        Object object;
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        File file4 = new File(file3, "compare_segm_results_corrected.txt");
        SegFileFilter segFileFilter = new SegFileFilter(stringArray);
        File[] fileArray = file.listFiles(segFileFilter);
        ArrayList<EvalResult> arrayList = new ArrayList<EvalResult>();
        for (n = 0; n < fileArray.length; ++n) {
            File file5 = fileArray[n];
            try {
                System.out.println("\n\nprocessing ref: " + file5.getAbsolutePath());
                String string = file5.getName();
                object = new File(file2, string);
                if (!((File)object).exists()) {
                    System.out.println("hypo file does not exist: " + ((File)object).getAbsolutePath());
                    continue;
                }
                SimpleFileDataSource simpleFileDataSource = new SimpleFileDataSource(file5, this.segmPattern);
                simpleFileDataSource.Init(1);
                SimpleFileDataSource simpleFileDataSource2 = new SimpleFileDataSource((File)object, this.segmPattern);
                simpleFileDataSource2.Init(1);
                Integer[] integerArray = simpleFileDataSource2.GetReferenceSegmentBreaks();
                LinearEvaluator linearEvaluator = new LinearEvaluator();
                linearEvaluator.Init(simpleFileDataSource, integerArray);
                String string2 = linearEvaluator.evaluate();
                System.out.println(string2);
                double d4 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.REGULAR);
                double d5 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.FP);
                double d6 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.FN);
                EvalResult evalResult = new EvalResult(0.0, 0.0, d4, 0.0, simpleFileDataSource.GetReferenceSegmentBreaks().length, integerArray.length);
                evalResult.SetFPFN(d5, d6);
                arrayList.add(evalResult);
                d += d4;
                d2 += d5;
                d3 += d6;
                Date date = new Date();
                System.out.println("END: " + date.toString());
                continue;
            }
            catch (Exception exception) {
                System.out.println("Exception in RunAPSeg");
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
        n = fileArray.length;
        double d7 = this.ComputeStdDevWinDiff(arrayList);
        object = "WinDiffRegular: " + String.valueOf(d / (double)n) + "\n";
        object = (String)object + "WinDiffFP: " + String.valueOf(d2 / (double)n) + "\n";
        object = (String)object + "WinDiffFN: " + String.valueOf(d3 / (double)n) + "\n";
        object = (String)object + "WinDiff std dev: " + String.valueOf(d7) + "\n";
        TextFileIO.OutputFile(file4, (String)object);
    }

    public double ComputeStdDevWinDiff(ArrayList<EvalResult> arrayList) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (EvalResult evalResult : arrayList) {
            d += evalResult.winDiff;
        }
        d /= (double)arrayList.size();
        for (EvalResult evalResult : arrayList) {
            double d4 = d - evalResult.winDiff;
            d2 += Math.pow(d4, 2.0);
        }
        d3 = Math.sqrt(d2 /= (double)arrayList.size());
        System.out.println("Ave:\t" + String.valueOf(d) + "\tVar:\t" + String.valueOf(d2) + "\tStd dev:t" + String.valueOf(d3));
        return d3;
    }

    public void TuneParameters(String string, String string2, String string3, boolean bl, Integer n, TokenizerFactory tokenizerFactory, boolean bl2, boolean bl3, Double d, Integer n2, double[] dArray, double[] dArray2, int[] nArray, String[] stringArray, String[] stringArray2) {
        Serializable serializable;
        Object object;
        File file = new File(string);
        File file2 = new File(string2);
        File file3 = new File(file2, string3);
        SegFileFilter segFileFilter = new SegFileFilter(stringArray2);
        TokenizerFactory tokenizerFactory2 = this.CreateTokenizerFactory();
        IDataSource[] iDataSourceArray = new IDataSource[]{};
        if (!bl) {
            object = file.listFiles(segFileFilter);
            iDataSourceArray = new IDataSource[((File[])object).length];
            for (int i = 0; i < ((File[])object).length; ++i) {
                serializable = object[i];
                try {
                    iDataSourceArray[i] = new SimpleFileDataSource((File)serializable, this.segmPattern);
                    iDataSourceArray[i].Init(1);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DfDictionary dfDictionary = new DfDictionary(iDataSourceArray, tokenizerFactory2, iDataSourceArray.length);
            try {
                dfDictionary.ProcessCorpus();
            }
            catch (Exception exception) {
                System.out.println("Exception in RUnSegmenter.TuneParameters when Processing dfDict:");
                exception.printStackTrace();
            }
            dfDictionary.ForgetCorpus();
        }
        object = new SegFileFilter(stringArray);
        File[] fileArray = file.listFiles((FileFilter)object);
        serializable = new ArrayList();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    Object object2;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    double d7 = 0.0;
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    double d8 = dArray[i];
                    double d9 = dArray2[j];
                    int n6 = nArray[k];
                    for (int i2 = 0; i2 < fileArray.length; ++i2) {
                        File file4 = fileArray[i2];
                        n6 = nArray[k];
                        Date date = new Date();
                        System.out.println("\n\nprocessing " + file4.getAbsolutePath());
                        System.out.println("parameters: p" + String.valueOf(d8) + " and d " + String.valueOf(d9) + " and win " + String.valueOf(n6));
                        try {
                            SimpleFileDataSource simpleFileDataSource = new SimpleFileDataSource(file4, this.segmPattern);
                            simpleFileDataSource.Init(1);
                            if (n6 >= simpleFileDataSource.GetNumChunks()) {
                                System.out.println("window too large (" + String.valueOf(n6) + ") when numChunks " + String.valueOf(simpleFileDataSource.GetNumChunks()));
                                n6 = simpleFileDataSource.GetNumChunks() - 1;
                                System.out.println("New win size" + String.valueOf(n6));
                            }
                            n4 += simpleFileDataSource.GetReferenceSegmentBreaks().length;
                            if (bl) {
                                iDataSourceArray = new IDataSource[]{simpleFileDataSource};
                            }
                            object2 = this.CreateConfiguredSegmenter(iDataSourceArray, simpleFileDataSource, bl, n, tokenizerFactory2, bl2, n6, bl3, d, n2, d8, d9, file2);
                            ((AbstractAPSegmenterDP)object2).Run();
                            TreeMap<Integer, TreeSet<Integer>> treeMap = ((AbstractAPSegmenterDP)object2).GetAssignments();
                            treeMap = ((AbstractAPSegmenterDP)object2).GetNonConflictingAssignments();
                            Integer[] integerArray = this.GetHypoBreaks(treeMap);
                            LinearEvaluator linearEvaluator = new LinearEvaluator();
                            linearEvaluator.Init(simpleFileDataSource, integerArray);
                            String string4 = linearEvaluator.evaluate();
                            double d10 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.REGULAR);
                            double d11 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.FP);
                            double d12 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.FN);
                            d3 += d10;
                            d5 += d11;
                            d7 += d12;
                            n5 += integerArray.length;
                            ++n3;
                            Date date2 = new Date();
                            continue;
                        }
                        catch (Exception exception) {
                            System.out.println("Exception in RunAPSeg.TuneParameters");
                            System.out.println(exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                    n6 = nArray[k];
                    double d13 = n4 / n3;
                    double d14 = n5 / n3;
                    d2 = d3 / (double)n3;
                    d4 = d5 / (double)n3;
                    d6 = d7 / (double)n3;
                    object2 = new EvalResult(d9, d8, d2, n6, d13, d14);
                    ((EvalResult)object2).SetFPFN(d4, d6);
                    ((ArrayList)serializable).add(object2);
                    System.out.println(String.valueOf(((EvalResult)object2).dampFactor) + "\t" + String.valueOf(((EvalResult)object2).prefValue) + "\t" + String.valueOf(((EvalResult)object2).winDiff) + "\t" + "FP:\t" + String.valueOf(((EvalResult)object2).winFP) + "\t" + "FP:\t" + String.valueOf(((EvalResult)object2).winFN) + "\t" + String.valueOf(n6) + "\t" + String.valueOf(d13) + "\t" + String.valueOf(d14));
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("damp\tpref\twinSize\twinDiff\twinFP\twinFN\n");
        Iterator iterator = ((ArrayList)serializable).iterator();
        while (iterator.hasNext()) {
            EvalResult evalResult = (EvalResult)iterator.next();
            stringBuilder.append(String.valueOf(evalResult.dampFactor) + "\t" + String.valueOf(evalResult.prefValue) + "\t" + String.valueOf(evalResult.winSize) + "\t" + String.valueOf(evalResult.winDiff) + "\t" + String.valueOf(evalResult.winFP) + "\t" + String.valueOf(evalResult.winFN) + "\t" + String.valueOf(evalResult.ref) + "\t" + String.valueOf(evalResult.hypo) + "\n");
        }
        TextFileIO.OutputFile(file3, stringBuilder.toString());
    }

    public void TuneParametersWinRatios(String string, String string2, String string3, boolean bl, Integer n, TokenizerFactory tokenizerFactory, boolean bl2, boolean bl3, Double d, Integer n2, double[] dArray, double[] dArray2, double[] dArray3, String[] stringArray, String[] stringArray2) {
        Serializable serializable;
        Object object;
        File file = new File(string);
        File file2 = new File(string2);
        File file3 = new File(file2, string3);
        SegFileFilter segFileFilter = new SegFileFilter(stringArray2);
        TokenizerFactory tokenizerFactory2 = this.CreateTokenizerFactory();
        IDataSource[] iDataSourceArray = new IDataSource[]{};
        if (!bl) {
            object = file.listFiles(segFileFilter);
            iDataSourceArray = new IDataSource[((File[])object).length];
            for (int i = 0; i < ((File[])object).length; ++i) {
                serializable = object[i];
                try {
                    iDataSourceArray[i] = new SimpleFileDataSource((File)serializable, this.segmPattern);
                    iDataSourceArray[i].Init(1);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DfDictionary dfDictionary = new DfDictionary(iDataSourceArray, tokenizerFactory2, iDataSourceArray.length);
            try {
                dfDictionary.ProcessCorpus();
            }
            catch (Exception exception) {
                System.out.println("Exception in RUnSegmenter.TuneParameters when Processing dfDict:");
                exception.printStackTrace();
            }
            dfDictionary.ForgetCorpus();
        }
        object = new SegFileFilter(stringArray);
        File[] fileArray = file.listFiles((FileFilter)object);
        serializable = new ArrayList();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                for (int k = 0; k < dArray3.length; ++k) {
                    Object object2;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    double d7 = 0.0;
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    double d8 = dArray[i];
                    double d9 = dArray2[j];
                    double d10 = dArray3[k];
                    int n6 = 0;
                    for (int i2 = 0; i2 < fileArray.length; ++i2) {
                        File file4 = fileArray[i2];
                        boolean bl4 = bl2;
                        Date date = new Date();
                        try {
                            object2 = new SimpleFileDataSource(file4, this.segmPattern);
                            object2.Init(1);
                            if (object2.GetNumChunks() > 400 && d10 > 0.7) {
                                d10 = 0.7;
                            }
                            if (d10 > 0.95) {
                                if (object2.GetNumChunks() > 400) {
                                    d10 = 0.7;
                                } else {
                                    bl4 = false;
                                }
                            }
                            Float f = new Float(d10);
                            Integer n7 = new Integer(object2.GetNumChunks());
                            n6 = Math.round(f.floatValue() * (float)n7.intValue());
                            System.out.println("\n\nprocessing " + file4.getAbsolutePath());
                            System.out.println("parameters: p" + String.valueOf(d8) + " and d " + String.valueOf(d9) + " and win ratio" + String.valueOf(dArray3[k]) + " curWinSize " + n6);
                            if (n6 >= object2.GetNumChunks()) {
                                System.out.println("window too large (" + String.valueOf(n6) + ") when numChunks " + String.valueOf(object2.GetNumChunks()));
                                n6 = object2.GetNumChunks() - 1;
                                System.out.println("New win size" + String.valueOf(n6));
                            }
                            n4 += object2.GetReferenceSegmentBreaks().length;
                            if (bl) {
                                iDataSourceArray = new IDataSource[]{object2};
                            }
                            AbstractAPSegmenterDP abstractAPSegmenterDP = this.CreateConfiguredSegmenter(iDataSourceArray, (IDataSource)object2, bl, n, tokenizerFactory2, bl4, n6, bl3, d, n2, d8, d9, file2);
                            abstractAPSegmenterDP.Run();
                            TreeMap<Integer, TreeSet<Integer>> treeMap = abstractAPSegmenterDP.GetAssignments();
                            treeMap = abstractAPSegmenterDP.GetNonConflictingAssignments();
                            Integer[] integerArray = this.GetHypoBreaks(treeMap);
                            LinearEvaluator linearEvaluator = new LinearEvaluator();
                            linearEvaluator.Init((IDataSource)object2, integerArray);
                            String string4 = linearEvaluator.evaluate();
                            double d11 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.REGULAR);
                            double d12 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.FP);
                            double d13 = linearEvaluator.ComputeWinDiff(LinearEvaluator.WINDIFF_MODE.FN);
                            d3 += d11;
                            d5 += d12;
                            d7 += d13;
                            n5 += integerArray.length;
                            ++n3;
                            Date date2 = new Date();
                            d10 = dArray3[k];
                            continue;
                        }
                        catch (Exception exception) {
                            System.out.println("Exception in RunAPSeg.TuneParameters");
                            System.out.println(exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                    double d14 = n4 / n3;
                    double d15 = n5 / n3;
                    d2 = d3 / (double)n3;
                    d4 = d5 / (double)n3;
                    d6 = d7 / (double)n3;
                    object2 = new EvalResult(d9, d8, d2, d10, d14, d15);
                    ((EvalResult)object2).SetFPFN(d4, d6);
                    ((ArrayList)serializable).add(object2);
                    System.out.println(String.valueOf(((EvalResult)object2).dampFactor) + "\t" + String.valueOf(((EvalResult)object2).prefValue) + "\t" + String.valueOf(((EvalResult)object2).winDiff) + "\t" + "FP:\t" + String.valueOf(((EvalResult)object2).winFP) + "\t" + "FP:\t" + String.valueOf(((EvalResult)object2).winFN) + "\t" + String.valueOf(d10) + "\t" + String.valueOf(d14) + "\t" + String.valueOf(d15));
                    System.out.println("fileCounter: " + String.valueOf(n3));
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("damp\tpref\twinSize\twinDiff\twinFP\twinFN\n");
        Iterator iterator = ((ArrayList)serializable).iterator();
        while (iterator.hasNext()) {
            EvalResult evalResult = (EvalResult)iterator.next();
            stringBuilder.append(String.valueOf(evalResult.dampFactor) + "\t" + String.valueOf(evalResult.prefValue) + "\t" + String.valueOf(evalResult.winSize) + "\t" + String.valueOf(evalResult.winDiff) + "\t" + String.valueOf(evalResult.winFP) + "\t" + String.valueOf(evalResult.winFN) + "\t" + String.valueOf(evalResult.ref) + "\t" + String.valueOf(evalResult.hypo) + "\n");
        }
        TextFileIO.OutputFile(file3, stringBuilder.toString());
    }

    Integer[] GetHypoBreaks(TreeMap<Integer, TreeSet<Integer>> treeMap) {
        if (treeMap == null || treeMap.isEmpty()) {
            return new Integer[0];
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Integer n : treeMap.keySet()) {
            TreeSet<Integer> treeSet2 = treeMap.get(n);
            Integer n2 = treeSet2.last();
            treeSet.add(n2);
        }
        Integer[] integerArray = treeSet.toArray(new Integer[0]);
        return integerArray;
    }

    AbstractAPSegmenterDP CreateAffinityPropagationSegmenter(ISimComputer iSimComputer, double d, double d2, boolean bl) throws Exception {
        int n = 1000;
        AbstractAPSegmenterDP abstractAPSegmenterDP = !bl ? new AffinityPropagationSegmenterDense() : new AffinityPropagationSegmenterSparse();
        abstractAPSegmenterDP.Init(iSimComputer);
        abstractAPSegmenterDP.setDampFactor(d2);
        abstractAPSegmenterDP.setMaxIterations(n);
        abstractAPSegmenterDP.SetPreferences(d);
        return abstractAPSegmenterDP;
    }

    public void PrintRefBreaks(IDataSource iDataSource) {
        Integer[] integerArray;
        for (Integer n : integerArray = iDataSource.GetReferenceSegmentBreaks()) {
            System.out.println("Ref break after " + n.toString());
        }
    }

    TokenizerFactory CreateTokenizerFactory() {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        String string = TextFileIO.ReadTextFile(stopWordsFile);
        String[] stringArray = TextFileIO.LinesToArray(string);
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i].trim();
            if (((String)object).isEmpty()) continue;
            hashSet.add((String)object);
        }
        String string2 = "[a-zA-Z]{2,}|[0-9]+|\\S{2,}";
        object = Pattern.compile("[\\_]+|[^\\W]+");
        TokenizerFactory tokenizerFactory = new RegExTokenizerFactory(string2);
        if (lowerCase) {
            tokenizerFactory = new LowerCaseTokenizerFactory(tokenizerFactory, new Locale("en"));
        }
        if (useStemmer) {
            tokenizerFactory = new PorterStemmerTokenizerFactory(tokenizerFactory);
        }
        if (removeStopWords) {
            tokenizerFactory = new StopTokenizerFactory(tokenizerFactory, hashSet);
        }
        tokenizerFactory = new RegExFilteredTokenizerFactory(tokenizerFactory, (Pattern)object);
        return tokenizerFactory;
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        String[] stringArray2;
        String[] stringArray3;
        String string;
        String string2;
        String string3;
        CommandLineParser commandLineParser = new CommandLineParser(new ParamGroup(new IParam[]{new OrGroup(new IParam[]{new IfGroup("-run", new IParam[]{new DoubleParam("-preference", null), new DoubleParam("-damping", null), new OrGroup(new IParam[]{new IntParam("-windowSize", null), new DoubleParam("-windowRatio", null)})}), new IfGroup("-tune", new IParam[]{new DoubleArrayParam("-tunePrefs", null), new DoubleArrayParam("-tuneDamps", null), new OrGroup(new IParam[]{new DoubleArrayParam("-tuneWinRatios", null), new IntArrayParam("-tuneWinSizes", null)})})}), new DirectoryParam("-inputDir", null), new DirectoryParam("-outputDir", null), new StringParam("-resultFile", ".+", "results.txt"), new StringArrayParam("-inputExtensions", ".+", new String[]{""}), new StringArrayParam("-corpusExtensions", ".+", new String[]{""}), new BoolParam("-sparse", true), new IfGroup("-useSegmentDf", new IParam[]{new IntParam("-numTFIDFsegments", null)}), new IfGroup("-smoothing", new IParam[]{new DoubleParam("-smoothingAlpha", null), new IntParam("-smoothingWindow", null)})}));
        Integer n = null;
        Double d = null;
        Integer n2 = null;
        Double d2 = null;
        Double d3 = null;
        Integer n3 = null;
        Double d4 = null;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        int[] nArray = null;
        StringBuilder stringBuilder = new StringBuilder("Parameters in use:\n");
        try {
            commandLineParser.Parse(stringArray);
            string3 = commandLineParser.getStringValue("-inputDir");
            string2 = commandLineParser.getStringValue("-outputDir");
            string = commandLineParser.getStringValue("-resultFile");
            stringArray3 = commandLineParser.getStringArrayValue("-corpusExtensions");
            stringArray2 = commandLineParser.getStringArrayValue("-inputExtensions");
            stringBuilder.append("inputFilePath: " + string3 + "\n");
            stringBuilder.append("outputDirPath: " + string2 + "\n");
            stringBuilder.append("resultFileName: " + string + "\n");
            for (String string4 : stringArray3) {
                stringBuilder.append("corpusExt: " + string4 + "\n");
            }
            for (String string4 : stringArray2) {
                stringBuilder.append("intputExt: " + string4 + "\n");
            }
            bl4 = commandLineParser.getBoolValue("-useSegmentDf");
            stringBuilder.append("useSegmentDf: " + bl4 + "\n");
            if (bl4) {
                n = commandLineParser.getIntValue("-numTFIDFsegments");
                stringBuilder.append("\tnumTFIDFsegments: " + n + "\n");
            }
            bl3 = commandLineParser.getBoolValue("-sparse");
            stringBuilder.append("useSparseSegmenter: " + bl3 + "\n");
            bl2 = commandLineParser.getBoolValue("-smoothing");
            stringBuilder.append("useSmoothing: " + bl2 + "\n");
            if (bl2) {
                d = commandLineParser.getDoubleValue("-smoothingAlpha");
                n2 = commandLineParser.getIntValue("-smoothingWindow");
                stringBuilder.append("\tparzenAlpha: " + d + "\n");
                stringBuilder.append("\tparzenWindowSize: " + n2 + "\n");
            }
            try {
                commandLineParser.getBoolValue("-run");
                bl = true;
            }
            catch (Exception exception) {
                commandLineParser.getBoolValue("-tune");
                bl = false;
            }
            if (bl) {
                stringBuilder.append("run: true \n");
                d2 = commandLineParser.getDoubleValue("-preference");
                d3 = commandLineParser.getDoubleValue("-damping");
                stringBuilder.append("\tcurPref: " + d2 + "\n");
                stringBuilder.append("\tcurDamp: " + d3 + "\n");
                try {
                    n3 = commandLineParser.getIntValue("-windowSize");
                    stringBuilder.append("\tcurWinSize: " + n3 + "\n");
                }
                catch (Exception exception) {
                    d4 = commandLineParser.getDoubleValue("-windowRatio");
                    stringBuilder.append("\tcurWinRatio: " + d4 + "\n");
                }
            } else {
                stringBuilder.append("tune parameters: true \n");
                dArray = commandLineParser.getDoubleArrayValue("-tunePrefs");
                object = new StringBuilder("\tallPrefs: ");
                for (double d5 : dArray) {
                    ((StringBuilder)object).append(d5 + " ");
                }
                stringBuilder.append(object + "\n");
                dArray2 = commandLineParser.getDoubleArrayValue("-tuneDamps");
                Object object2 = new StringBuilder("\tallDamps: ");
                for (double d6 : dArray2) {
                    ((StringBuilder)object2).append(d6 + " ");
                }
                stringBuilder.append(object2 + "\n");
                try {
                    dArray3 = commandLineParser.getDoubleArrayValue("-tuneWinRatios");
                    Object object3 = new StringBuilder("\tallWinRatios: ");
                    for (double d7 : dArray3) {
                        ((StringBuilder)object3).append(d7 + " ");
                    }
                    stringBuilder.append(object3 + "\n");
                }
                catch (Exception exception) {
                    nArray = commandLineParser.getIntArrayValue("-tuneWinSizes");
                    StringBuilder stringBuilder2 = new StringBuilder("\tallWinSizes: ");
                    int[] nArray2 = nArray;
                    int n4 = nArray2.length;
                    for (int i = 0; i < n4; ++i) {
                        double d8 = nArray2[i];
                        stringBuilder2.append(d8 + " ");
                    }
                    stringBuilder.append(stringBuilder2 + "\n");
                }
                bl = false;
            }
            System.out.println("Parameters: \n" + stringBuilder.toString());
        }
        catch (Exception exception) {
            System.out.println("Usage: \n[ -run -preference <double> -damping <double> [-windowSize <int> | -windowRatio <double>] ]\n\tOR\n[ -tune-tunePrefs <comma separated doubles> -tuneDamps <comma separated doubles> [-tuneWinSizes <comma separated ints> | -tuneWinRatios <comma separated doubles>] ]\n-sparse <true | false>\n(-useSegmentDf)\n\t-numTFIDFsegments <int>\n(-smoothing)\n\t-smoothingWindow <int> -smoothingAlpha <double>\n-corpusExtensions <comma separated extensions>\n-inputExtensions <comma separated extensions>\n(Indented parameters are mandatory if the preceding unindented option in set.)\nPlease read README and see examples of configuration files in ./config");
            return;
        }
        object = new RunSegmenter();
        TokenizerFactory tokenizerFactory = ((RunSegmenter)object).CreateTokenizerFactory();
        if (bl) {
            ((RunSegmenter)object).Run(string3, string2, string, d2, d3, bl4, n, tokenizerFactory, bl3, n3, d4, bl2, d, n2, stringArray2, stringArray3);
        } else if (nArray != null) {
            ((RunSegmenter)object).TuneParameters(string3, string2, string, bl4, n, tokenizerFactory, bl3, bl2, d, n2, dArray, dArray2, nArray, stringArray2, stringArray3);
        } else if (dArray3 != null) {
            ((RunSegmenter)object).TuneParametersWinRatios(string3, string2, string, bl4, n, tokenizerFactory, bl3, bl2, d, n2, dArray, dArray2, dArray3, stringArray2, stringArray3);
        }
    }

    private class EvalResult {
        public double dampFactor = 0.0;
        public double prefValue = 0.0;
        public double winSize = 0.0;
        public double winDiff = 1.0;
        public double winFP = 1.0;
        public double winFN = 1.0;
        public double ref = 0.0;
        public double hypo = 0.0;

        EvalResult(double d, double d2, double d3, double d4, double d5, double d6) {
            this.dampFactor = d;
            this.prefValue = d2;
            this.winSize = d4;
            this.winDiff = d3;
            this.ref = d5;
            this.hypo = d6;
        }

        public void SetFPFN(double d, double d2) {
            this.winFP = d;
            this.winFN = d2;
        }
    }

    private class SegFileFilter
    implements FileFilter {
        String[] okExtensions = null;

        public SegFileFilter(String[] stringArray) {
            this.okExtensions = stringArray;
        }

        @Override
        public boolean accept(File file) {
            for (String string : this.okExtensions) {
                if (!file.getName().toLowerCase().endsWith(string)) continue;
                return true;
            }
            return false;
        }
    }
}

