/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import settings.Parameters;
import tdg.TDNode;
import tdg.corpora.DepCorpus;
import tdg.corpora.WsjD;
import tsg.TSNode;
import tsg.corpora.ConstCorpus;
import tsg.corpora.Wsj;
import util.FileUtil;
import util.Utility;

public class ConstDepConverter {
    public static void printMSTOutput(ConstCorpus inputPenn, File outputMaltFile, boolean blind, boolean labels) {
        PrintWriter writer = FileUtil.getPrintWriter(outputMaltFile);
        for (TSNode tree : inputPenn.treeBank) {
            writer.println(ConstDepConverter.toMSTAnnotation(tree, blind, labels, false));
        }
        writer.close();
    }

    public static String toMSTAnnotation(TSNode TSN, boolean blind, boolean useLabels, boolean useArguments) {
        String[] stringArray;
        if (TSN.hasWrongHeadAssignment()) {
            System.err.println("Wrong head annotation for: " + TSN);
            return null;
        }
        String words = "";
        String postags = "";
        String labels = "";
        String indexes = "";
        List<TSNode> terminals = TSN.collectLexicalItems();
        for (TSNode leaf : terminals) {
            TSNode ancestor = leaf.parent;
            String dependentPOS = ancestor.label;
            words = String.valueOf(words) + leaf.label + "\t";
            while (ancestor.isHeadMarked() && !ancestor.isRoot()) {
                ancestor = ancestor.parent;
            }
            if (dependentPOS.endsWith("-A")) {
                dependentPOS = dependentPOS.substring(0, dependentPOS.length() - 2);
            }
            postags = useArguments && ancestor.isArgumentMarked() ? String.valueOf(postags) + dependentPOS + "-A\t" : String.valueOf(postags) + dependentPOS + "\t";
            if (blind) {
                indexes = String.valueOf(indexes) + "-1\t";
                if (!useLabels) continue;
                labels = String.valueOf(labels) + "LAB\t";
                continue;
            }
            if (ancestor.isRoot()) {
                indexes = String.valueOf(indexes) + "0\t";
                if (!useLabels) continue;
                labels = String.valueOf(labels) + "ROOT\t";
                continue;
            }
            String DLabel = ancestor.label;
            ancestor = ancestor.parent;
            String MLabel = ancestor.label;
            String HLabel = ancestor.getHeadDaughter().label;
            TSNode head = ancestor.getAnchorThroughPercolation();
            String headPOS = head.parent.label;
            int indexHead = terminals.indexOf(head) + 1;
            indexes = String.valueOf(indexes) + indexHead + "\t";
            if (!useLabels) continue;
            String depLabel = ConstDepConverter.getMaltDependencyLabel(MLabel, DLabel, headPOS == HLabel);
            labels = String.valueOf(labels) + depLabel + "\t";
        }
        String result = "";
        if (useLabels) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = words;
            stringArray2[1] = postags;
            stringArray2[2] = labels;
            stringArray = stringArray2;
            stringArray2[3] = indexes;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = words;
            stringArray3[1] = postags;
            stringArray = stringArray3;
            stringArray3[2] = indexes;
        }
        String[] resultArray = stringArray;
        int i = 0;
        while (i < resultArray.length) {
            result = String.valueOf(result) + resultArray[i].trim() + "\n";
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static String toMaltTabAnnotation(TSNode TDN, int rootIndex, boolean blind, boolean labels) {
        if (!blind && TDN.hasWrongHeadAssignment()) {
            System.err.println("Wrong head annotation for: " + TDN);
            return null;
        }
        result = "";
        terminals = TDN.collectLexicalItems();
        for (TSNode leaf : terminals) {
            ancestor = leaf.parent;
            dependentPOS = ancestor.label;
            if (!blind) ** GOTO lbl13
            result = String.valueOf(result) + leaf.label + "\t" + dependentPOS + "\n";
            continue;
lbl-1000:
            // 1 sources

            {
                ancestor = ancestor.parent;
lbl13:
                // 2 sources

                ** while (ancestor.isHeadMarked() && !ancestor.isRoot())
            }
lbl14:
            // 1 sources

            indexHead = -1;
            depLabel = null;
            LLabel = leaf.label;
            if (ancestor.isRoot()) {
                indexHead = rootIndex;
                depLabel = "ROOT";
            } else {
                DLabel = ancestor.label;
                ancestor = ancestor.parent;
                MLabel = ancestor.label;
                HLabel = ancestor.getHeadDaughter().label;
                head = ancestor.getAnchorThroughPercolation();
                headPOS = head.parent.label;
                indexHead = terminals.indexOf(head) + 1;
                depLabel = ConstDepConverter.getMaltDependencyLabel(MLabel, DLabel, headPOS == HLabel);
            }
            result = String.valueOf(result) + LLabel + "\t" + dependentPOS + "\t" + indexHead;
            if (labels) {
                result = String.valueOf(result) + "\t" + depLabel;
            }
            result = String.valueOf(result) + "\n";
        }
        return result;
    }

    public static String getMaltDependencyLabel(String MLabel, String DLabel, boolean HLabelIsPOS) {
        MLabel = TSNode.removeSemanticTag(MLabel);
        if (Utility.isPunctuation(DLabel)) {
            return "P";
        }
        if (DLabel.contains("-SBJ")) {
            return "SUB";
        }
        if (DLabel.contains("-PRD")) {
            return "PRD";
        }
        if (MLabel.equals("VP") && HLabelIsPOS && DLabel.equals("NP")) {
            return "OBJ";
        }
        if (MLabel.equals("VP") && HLabelIsPOS && TSNode.removeSemanticTag(DLabel).equals("VP")) {
            return "VC";
        }
        if (MLabel.equals("SBAR") && TSNode.removeSemanticTag(DLabel).equals("S")) {
            return "SBAR";
        }
        if (Utility.matchString(MLabel, new String[]{"VP", "S", "SQ", "SINV", "SBAR"})) {
            return "VMOD";
        }
        if (Utility.matchString(MLabel, new String[]{"NP", "NAC", "NX", "WHNP"})) {
            return "NMOD";
        }
        if (Utility.matchString(MLabel, new String[]{"ADJP", "ADVP", "QP", "WHADJP", "WHADVP"})) {
            return "AMOD";
        }
        if (Utility.matchString(MLabel, new String[]{"PP", "WHPP"})) {
            return "PMOD";
        }
        return "DEP";
    }

    public static void printMaltOutput(ConstCorpus inputPenn, File outputMaltFile, boolean blind) {
        inputPenn.correctHeadAnnotation();
        PrintWriter writer = FileUtil.getPrintWriter(outputMaltFile);
        for (TSNode tree : inputPenn.treeBank) {
            writer.println(ConstDepConverter.toMaltTabAnnotation(tree, 0, blind, true));
        }
        writer.close();
    }

    public static void convertCollins97() {
        File ConstCollinsDir = new File(Wsj.WsjOriginalCleanedCollins97);
        File DepCollinsDir = new File(WsjD.WsjCOLLINS97);
        DepCollinsDir.mkdirs();
        Object[] fileList = ConstCollinsDir.listFiles();
        Arrays.sort(fileList);
        Object[] objectArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            Object inputFile = objectArray[n2];
            File outputDepFile = new File(DepCollinsDir + "/" + ((File)inputFile).getName());
            PrintWriter output = FileUtil.getPrintWriter(outputDepFile);
            ArrayList<TSNode> constCorpus = new ConstCorpus((File)inputFile, (String)"Collins", (boolean)false).treeBank;
            for (TSNode tsn : constCorpus) {
                output.println(ConstDepConverter.toMaltTabAnnotation(tsn, -1, false, false));
            }
            output.close();
            ++n2;
        }
    }

    public static void convertCollins97_ulab() {
        File ConstCollinsDir = new File(Wsj.WsjOriginalCleanedCollins97);
        File DepCollinsDir = new File(WsjD.WsjCOLLINS97_ulab);
        DepCollinsDir.mkdirs();
        Object[] fileList = ConstCollinsDir.listFiles();
        Arrays.sort(fileList);
        Object[] objectArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            Object inputFile = objectArray[n2];
            File outputDepFile = new File(DepCollinsDir + "/" + ((File)inputFile).getName());
            PrintWriter output = FileUtil.getPrintWriter(outputDepFile);
            ArrayList<TSNode> constCorpus = new ConstCorpus((File)inputFile, (String)"Collins", (boolean)false).treeBank;
            for (TSNode tsn : constCorpus) {
                output.println(ConstDepConverter.toMSTAnnotation(tsn, false, false, false));
            }
            output.close();
            ++n2;
        }
    }

    public static void convertCollins99_ulab() {
        File ConstCollinsDir = new File(Wsj.WsjOriginalCleanedCollins99);
        File DepCollinsDir = new File(WsjD.WsjCOLLINS99Arg_ulab);
        DepCollinsDir.mkdirs();
        Object[] fileList = ConstCollinsDir.listFiles();
        Arrays.sort(fileList);
        Object[] objectArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            Object inputFile = objectArray[n2];
            if (!((File)inputFile).isDirectory()) {
                File outputDepFile = new File(DepCollinsDir + "/" + ((File)inputFile).getName());
                PrintWriter output = FileUtil.getPrintWriter(outputDepFile);
                ArrayList<TSNode> constCorpus = new ConstCorpus((File)inputFile, (String)"Collins", (boolean)false).treeBank;
                for (TSNode tsn : constCorpus) {
                    output.println(ConstDepConverter.toMSTAnnotation(tsn, false, false, true));
                }
                output.close();
            }
            ++n2;
        }
    }

    public static void convertYM() {
        File constYMDir = new File(Wsj.WsjOriginalCleanedYM);
        File depYMDir = new File(String.valueOf(WsjD.WsjDepBase) + "YM_check");
        depYMDir.mkdirs();
        Object[] fileList = constYMDir.listFiles();
        Arrays.sort(fileList);
        Object[] objectArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            Object inputFile = objectArray[n2];
            File outputDepFile = new File(depYMDir + "/" + ((File)inputFile).getName());
            PrintWriter output = FileUtil.getPrintWriter(outputDepFile);
            ArrayList<TSNode> constCorpus = new ConstCorpus((File)inputFile, (String)"YM", (boolean)false).treeBank;
            for (TSNode tsn : constCorpus) {
                output.println(ConstDepConverter.toMaltTabAnnotation(tsn, -1, false, false));
            }
            output.close();
            ++n2;
        }
    }

    public static void convertMSTulab() {
        File constYMDir = new File(Wsj.WsjOriginalCleanedYM);
        File depMSTDir = new File(String.valueOf(WsjD.WsjDepBase) + "MST_ulab");
        depMSTDir.mkdirs();
        Object[] fileList = constYMDir.listFiles();
        Arrays.sort(fileList);
        Object[] objectArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            Object inputFile = objectArray[n2];
            File outputDepFile = new File(depMSTDir + "/" + ((File)inputFile).getName());
            PrintWriter output = FileUtil.getPrintWriter(outputDepFile);
            ArrayList<TSNode> constCorpus = new ConstCorpus((File)inputFile, (String)"YM", (boolean)false).treeBank;
            for (TSNode tsn : constCorpus) {
                output.println(ConstDepConverter.toMSTAnnotation(tsn, false, false, false));
            }
            output.close();
            ++n2;
        }
    }

    public static void convertMagerman() {
        File constYMDir = new File(Wsj.WsjOriginalCleanedMagerman);
        File depMSTDir = new File(String.valueOf(WsjD.WsjDepBase) + "Magerman");
        depMSTDir.mkdirs();
        Object[] fileList = constYMDir.listFiles();
        Arrays.sort(fileList);
        Parameters.logFile = new File(depMSTDir + "/conversionLog.txt");
        Object[] objectArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            Object inputFile = objectArray[n2];
            File outputDepFile = new File(depMSTDir + "/" + ((File)inputFile).getName());
            PrintWriter output = FileUtil.getPrintWriter(outputDepFile);
            ConstCorpus constCorpus = new ConstCorpus((File)inputFile, "YM", false);
            constCorpus.correctHeadAnnotation();
            for (TSNode tsn : constCorpus.treeBank) {
                output.println(ConstDepConverter.toMaltTabAnnotation(tsn, -1, false, false));
            }
            output.close();
            ++n2;
        }
    }

    public static void convertNaive() {
        File constYMDir = new File(Wsj.WsjOriginalCleanedRandom);
        File depMSTDir = new File(String.valueOf(WsjD.WsjDepBase) + "Random");
        depMSTDir.mkdirs();
        Object[] fileList = constYMDir.listFiles();
        Arrays.sort(fileList);
        Parameters.logFile = new File(depMSTDir + "/conversionLog.txt");
        Object[] objectArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            Object inputFile = objectArray[n2];
            File outputDepFile = new File(depMSTDir + "/" + ((File)inputFile).getName());
            PrintWriter output = FileUtil.getPrintWriter(outputDepFile);
            ConstCorpus constCorpus = new ConstCorpus((File)inputFile, "Naive", false);
            for (TSNode tsn : constCorpus.treeBank) {
                output.println(ConstDepConverter.toMaltTabAnnotation(tsn, -1, false, false));
            }
            output.close();
            ++n2;
        }
    }

    public static void tabToYMConverter() {
        String path = "/scratch/fsangati/CORPUS/WSJ/DEPENDENCY/Entropy/";
        File inFile = new File(String.valueOf(path) + "wsj-02-11.tab");
        File outFile = new File(String.valueOf(path) + "wsj-02-11.dep");
        ArrayList depCorpus = DepCorpus.readTreebankFromFileMALT((File)inFile, (int)1000);
        PrintWriter output = FileUtil.getPrintWriter(outFile);
        for (TDNode tdn : depCorpus) {
            output.println(tdn.toStringMALTulab(-1, false, false));
        }
        output.close();
    }

    public static void main_old(String[] args) {
        File inputPennCorpus = new File("/scratch/fsangati/CORPUS/WSJ/CONSTITUENCY/ORIGINAL_COLLINS_97/wsj-22.mrg");
        File ouputNoTraceCorpus = new File("/scratch/fsangati/CORPUS/WSJ/CONSTITUENCY/COLLINS_97_NOTRACES/wsj-22.mrg");
        ConstCorpus corpus = new ConstCorpus(inputPennCorpus, "noname");
        corpus.removeTraces(Wsj.traceTag);
        corpus.removeNumbersInLables();
        corpus.removeRedundantRules();
        corpus.toFile_Complete(ouputNoTraceCorpus, false, false);
    }

    public static void main(String[] args) {
        ConstDepConverter.convertCollins99_ulab();
    }
}

