#!/bin/bash
set -ex

export WANDB_DIR="/mnt//reddit_mud/raw_all/emnlp/models/wandb"


CUDA_VISIBLE_DEVICES=1 python tinystyle_train.py \
--learning_rate 1e-5 \
--batch_size 16 \
--accumulation_steps 4 \
--out_dir /mnt//reddit_mud/raw_all/emnlp/supervised_ft_models/enc_dec_ft_v2_config_1_fixed \
--checkpoint '/mnt//reddit_mud/raw_all/emnlp/models/enc_dec_cond/2024-05-05-03.31.44_backup/best_model_google_t5-v1_1-large_1e-05_64.pt' \
--warmup_steps 0 \
--max_steps 100000000 \
--ctrl_embed_dim 768 \
--style_embed style_embedding \
--model_name google/t5-v1_1-large \
--data_file_path '/mnt//reddit_mud/raw_all//emnlp_ft_dataset_v2_fixed/full_dataset/reddit_emnlp_with_style_embeds/' \
--seed 42 \
--max_encoder_len 80 \
--max_decoder_len 80 \
--max_val_batch 200 \
--input_key "source_text" \
--output_key "output" \
--eval_freq 500