/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

public final class MutableDouble
extends Number
implements Comparable<MutableDouble> {
    private double d;
    private static final long serialVersionUID = 624465615824626762L;

    public void set(double d) {
        this.d = d;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.d);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof MutableDouble && this.d == ((MutableDouble)obj).d;
    }

    public String toString() {
        return Double.toString(this.d);
    }

    @Override
    public int compareTo(MutableDouble anotherMutableDouble) {
        double thisVal = this.d;
        double anotherVal = anotherMutableDouble.d;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    @Override
    public int intValue() {
        return (int)this.d;
    }

    @Override
    public long longValue() {
        return (long)this.d;
    }

    @Override
    public short shortValue() {
        return (short)this.d;
    }

    @Override
    public byte byteValue() {
        return (byte)this.d;
    }

    @Override
    public float floatValue() {
        return (float)this.d;
    }

    @Override
    public double doubleValue() {
        return this.d;
    }

    public MutableDouble() {
        this(0.0);
    }

    public MutableDouble(double d) {
        this.d = d;
    }

    public MutableDouble(Number num) {
        this.d = num.doubleValue();
    }
}

