/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonParseException;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonRuntimeException;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Map;

public class CreateSubtreeNode
extends TsurgeonPattern {
    private AuxiliaryTree auxTree;

    public CreateSubtreeNode(TsurgeonPattern start, AuxiliaryTree tree) {
        this(start, null, tree);
    }

    public CreateSubtreeNode(TsurgeonPattern start, TsurgeonPattern end, AuxiliaryTree tree) {
        TsurgeonPattern[] tsurgeonPatternArray;
        if (end == null) {
            TsurgeonPattern[] tsurgeonPatternArray2 = new TsurgeonPattern[1];
            tsurgeonPatternArray = tsurgeonPatternArray2;
            tsurgeonPatternArray2[0] = start;
        } else {
            TsurgeonPattern[] tsurgeonPatternArray3 = new TsurgeonPattern[2];
            tsurgeonPatternArray3[0] = start;
            tsurgeonPatternArray = tsurgeonPatternArray3;
            tsurgeonPatternArray3[1] = end;
        }
        super("combineSubtrees", tsurgeonPatternArray);
        this.auxTree = tree;
        this.findFoot();
    }

    private void findFoot() {
        if (this.auxTree.foot == null) {
            if (!this.auxTree.tree.isLeaf()) {
                throw new TsurgeonParseException("No foot node found for " + this.auxTree);
            }
            this.auxTree.foot = this.auxTree.tree;
        }
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(CreateSubtreeNode.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            Tree startChild = this.childMatcher[0].evaluate(tree, tregex);
            Tree endChild = this.childMatcher.length == 2 ? this.childMatcher[1].evaluate(tree, tregex) : startChild;
            Tree parent = startChild.parent(tree);
            if (parent != endChild.parent(tree)) {
                throw new TsurgeonRuntimeException("Parents did not match for trees when applied to " + this);
            }
            AuxiliaryTree treeCopy = CreateSubtreeNode.this.auxTree.copy(this);
            ArrayList<Tree> children = Generics.newArrayList();
            ArrayList<Tree> innerChildren = Generics.newArrayList();
            boolean insideSpan = false;
            for (Tree child : parent.children()) {
                if (child == startChild || child == endChild) {
                    if (!insideSpan && startChild != endChild) {
                        insideSpan = true;
                        innerChildren.add(child);
                        continue;
                    }
                    insideSpan = false;
                    innerChildren.add(child);
                    treeCopy.foot.setChildren(innerChildren);
                    children.add(treeCopy.tree);
                    continue;
                }
                if (insideSpan) {
                    innerChildren.add(child);
                    continue;
                }
                children.add(child);
            }
            parent.setChildren(children);
            return tree;
        }
    }
}

