/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.common;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.common.ParserGrammar;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.io.PrintWriter;
import java.util.List;

public class ParsingThreadsafeProcessor
implements ThreadsafeProcessor<List<? extends HasWord>, ParserQuery> {
    ParserGrammar pqFactory;
    PrintWriter pwErr;

    public ParsingThreadsafeProcessor(ParserGrammar pqFactory) {
        this(pqFactory, null);
    }

    public ParsingThreadsafeProcessor(ParserGrammar pqFactory, PrintWriter pwErr) {
        this.pqFactory = pqFactory;
        this.pwErr = pwErr;
    }

    @Override
    public ParserQuery process(List<? extends HasWord> sentence) {
        ParserQuery pq = this.pqFactory.parserQuery();
        if (this.pwErr != null) {
            pq.parseAndReport(sentence, this.pwErr);
        } else {
            pq.parse(sentence);
        }
        return pq;
    }

    @Override
    public ThreadsafeProcessor<List<? extends HasWord>, ParserQuery> newInstance() {
        return this;
    }
}

