/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class ResultsPrinter {
    public String printResults(CoreMap goldStandard, CoreMap extractorOutput) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        ArrayList<CoreMap> mutableGold = new ArrayList<CoreMap>();
        mutableGold.addAll((Collection)goldStandard.get(CoreAnnotations.SentencesAnnotation.class));
        ArrayList<CoreMap> mutableOutput = new ArrayList<CoreMap>();
        mutableOutput.addAll((Collection)extractorOutput.get(CoreAnnotations.SentencesAnnotation.class));
        this.printResults(pw, mutableGold, mutableOutput);
        return sw.getBuffer().toString();
    }

    public String printResults(List<String> goldStandard, List<String> extractorOutput) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        this.printResultsUsingLabels(pw, goldStandard, extractorOutput);
        return sw.getBuffer().toString();
    }

    public abstract void printResults(PrintWriter var1, List<CoreMap> var2, List<CoreMap> var3);

    public abstract void printResultsUsingLabels(PrintWriter var1, List<String> var2, List<String> var3);

    public static void align(List<CoreMap> list1, List<CoreMap> list2) {
        boolean alignable = true;
        if (list1.size() != list2.size()) {
            alignable = false;
        }
        class CompareSentences
        implements Comparator<CoreMap> {
            CompareSentences() {
            }

            @Override
            public int compare(CoreMap sent1, CoreMap sent2) {
                String d1 = (String)sent1.get(CoreAnnotations.DocIDAnnotation.class);
                String d2 = (String)sent2.get(CoreAnnotations.DocIDAnnotation.class);
                if (d1 != null && d2 != null && !d1.equals(d2)) {
                    return d1.compareTo(d2);
                }
                String t1 = (String)sent1.get(CoreAnnotations.TextAnnotation.class);
                String t2 = (String)sent2.get(CoreAnnotations.TextAnnotation.class);
                return t1.compareTo(t2);
            }
        }
        Collections.sort(list1, new CompareSentences());
        Collections.sort(list2, new CompareSentences());
        for (int i = 0; i < list1.size(); ++i) {
            if (((String)list1.get(i).get(CoreAnnotations.TextAnnotation.class)).equals(list2.get(i).get(CoreAnnotations.TextAnnotation.class))) continue;
            alignable = false;
        }
        if (!alignable) {
            throw new RuntimeException("ResultsPrinter.align: gold standard sentences don't match extractor output sentences!");
        }
    }
}

