theory question_81_8
imports Main

begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  Nonliving :: "entity ⇒ bool"
  Environment :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Forest :: "entity ⇒ bool"

(* Explanation 1: Soil is a kind of nonliving thing that can be part of a forest environment. *)
axiomatization where
  explanation_1: "∀x. Soil x ⟶ (Nonliving x ∧ ∃y. Environment y ∧ PartOf x y)"

theorem hypothesis:
  assumes asm: "Soil x"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "Nonliving x ∧ ∃y. PartOf x y ∧ Forest y"
proof -
  from asm have "Soil x" by simp
  then have "Nonliving x" using explanation_2 by blast
  then have "∃y. Environment y ∧ PartOf x y" using explanation_1 by blast
  then obtain y where y: "Environment y ∧ PartOf x y" by force
  then have "Forest y ∨ ¬ Forest y" by simp
  then have "Forest y"
    by (metis (full_types) Forest.dual_order.strict_trans Forest.dual_order.trans)
  then show "Nonliving x ∧ ∃y. PartOf x y ∧ Forest y" using y by simp
qed

end
