theory question_23_5
imports Main

begin

typedecl entity
typedecl event

consts
  Hurricanes :: "entity ⇒ bool"
  Tornadoes :: "entity ⇒ bool"
  HighWinds :: "entity ⇒ bool"
  SharedCharacteristic :: "entity ⇒ entity ⇒ bool"
  DirectCharacteristic :: "entity ⇒ entity ⇒ bool"
  AlwaysSharedCharacteristic :: "entity ⇒ entity ⇒ bool"
  AlwaysDirectCharacteristic :: "entity ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: High wind speeds are a shared characteristic between hurricanes and tornadoes. *)
axiomatization where
  explanation_1: "∀x. (Hurricanes x ∨ Tornadoes x) ⟶ (∃y. HighWinds y ∧ SharedCharacteristic x y)"

(* Explanation 2: High wind speeds are a direct characteristic of both hurricanes and tornadoes. *)
axiomatization where
  explanation_2: "∀x e. (Hurricanes x ∨ Tornadoes x) ⟶ DirectCharacteristic e x ∧ HighWinds e"

(* Explanation 3: High wind speeds are always a shared characteristic of both hurricanes and tornadoes. *)
axiomatization where
  explanation_3: "∀x. (Hurricanes x ∨ Tornadoes x) ⟶ (∀y. AlwaysSharedCharacteristic x y ⟶ HighWinds y)"

(* Explanation 4: High wind speeds are always a direct characteristic of both hurricanes and tornadoes. *)
axiomatization where
  explanation_4: "∀x e. (Hurricanes x ∨ Tornadoes x) ⟶ (∀y. AlwaysDirectCharacteristic x y ⟶ DirectCharacteristic x y) ∧ HighWinds e"

theorem hypothesis:
  assumes asm: "Hurricanes x ∨ Tornadoes x"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃x e. Hurricanes x ∨ Tornadoes x ∧ HighWinds e ∧ Agent e x"
proof -
  from asm have "Hurricanes x ∨ Tornadoes x" by simp
  then have "∃e. HighWinds e ∧ DirectCharacteristic e x" using explanation_2 by blast
  then have "HighWinds e" using explanation_2 by simp
  then have "∃e. Hurricanes x ∨ Tornadoes x ∧ HighWinds e ∧ Agent e x" using asm by auto
  then show ?thesis by simp
qed

end
