theory question_23_1

imports Main

begin

typedecl entity

consts
  Hurricanes :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  HighWindSpeeds :: "entity ⇒ bool"
  Tornadoes :: "entity ⇒ bool"

(* Explanation 1: A hurricane is an entity with high wind speeds. *)
axiomatization where
  explanation_1: "∀x. Hurricanes x ⟶ Entity x ∧ HighWindSpeeds x"

(* Explanation 2: A tornado is an entity with high wind speeds. *)
axiomatization where
  explanation_2: "∀x. Tornadoes x ⟶ Entity x ∧ HighWindSpeeds x"

theorem hypothesis:
  assumes asm: "Hurricanes x ∨ Tornadoes y"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "HighWindSpeeds x ∧ HighWindSpeeds y"
proof -
  from asm have "Hurricanes x ⟶ Entity x ∧ HighWindSpeeds x" by (rule explanation_1)
  then have "HighWindSpeeds x" using asm by (simp add: ball_I)
  from asm have "Tornadoes y ⟶ Entity y ∧ HighWindSpeeds y" by (rule explanation_2)
  then have "HighWindSpeeds y" using asm by (simp add: ball_I)
  then show "HighWindSpeeds x ∧ HighWindSpeeds y" by (simp add: and.intro)
qed

end
