theory question_93_0

imports Main

begin

typedecl entity

consts
  AdultEchinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Echinoderms :: "entity ⇒ bool"

(* Explanation 1: Adult echinoderms have radial symmetry. *)
axiomatization where
  explanation_1: "∀x. AdultEchinoderms x ⟶ RadialSymmetry x"

(* Explanation 2: Echinoderms are represented by the starfish. *)
axiomatization where
  explanation_2: "∀x. Starfish x ⟶ Echinoderms x"

theorem hypothesis:
  assumes asm: "AdultStarfish x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "RadialSymmetry x"
proof -
  from asm have "Starfish x" by simp
  then have "Echinoderms x" using explanation_2 by blast
  then have "RadialSymmetry x" using explanation_1 by blast
  then show ?thesis by simp
qed

end
