theory question_96_0
imports Main

begin

typedecl entity
typedecl event

consts
  Child :: "entity ⇒ bool"
  Adult :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Group :: "entity ⇒ bool"
  Member :: "entity ⇒ entity ⇒ bool"
  Swimming :: "entity ⇒ bool"
  Large :: "entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  Red :: "entity ⇒ bool"
  Staircase :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Enter :: "entity ⇒ entity ⇒ event"

(* Explanation 1: Both children and adults are people. *)
axiomatization where
  explanation_1: "∀x. (Child x ∨ Adult x) ⟶ People x"

theorem hypothesis:
  (* Premise: Children and adults swim in large pool with red staircase. *)
  assumes asm: "Child c ∧ Swim c e ∨ Adult a ∧ Swim a e ∧ Large e ∧ Pool e ∧ Red r ∧ Staircase r ∧ Enter r e"
  (* Hypothesis: A group of people are swimming. *)
  shows "∃g x. Group g ∧ People x ∧ ∀z ∈ g. Member z x ∧ Swimming z"
proof -
  from asm have "Child c ∨ Adult a" by blast
  then have "People c" "People a" using explanation_1 by blast+
  obtain g where "Group g" by blast (rule exI)
  have "Member c g" "Member a g" using asm that by auto
  have "Swimming c" "Swimming a" using asm that by blast+
  show ?thesis using `Group g` `People c` `Swimming c` `People a` `Swimming a` by blast
qed

end
