theory question_93_0

imports Main

begin

typedecl entity
typedecl event

consts
  Lambs :: "entity ⇒ bool"
  Animals :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  Old :: "entity ⇒ bool"
  Chasing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Close :: "entity ⇒ entity ⇒ entity ⇒ bool"
  Background :: "entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"

(* Explanation: If a woman is old, then she is a woman. *)
axiomatization where
  explanation: "∀w. Old w ⟶ Woman w"

theorem hypothesis:
  (* Premise: An old woman is chasing two lambs in the background while being close to a background. *)
  assumes asm: "Old w ∧ Woman w ∧ Lambs l1 ∧ Lambs l2 ∧ Background b ∧ Chasing e ∧ Agent e w ∧ Patient e l1 ∧ Patient e l2 ∧ With w b"
  (* Hypothesis: There exists a woman, an animal, and another animal. *)
  shows "∃w a1 a2. Woman w ∧ Animals a1 ∧ Animals a2"
proof -
  from asm have "Lambs l1" "Lambs l2" by auto
  then have "Animals l1" "Animals l2" by simp
  from asm have "Woman w" by auto
  show ?thesis using asm by blast
qed

end
