theory question_85_3
imports Main

begin

typedecl entity

consts
  FlowerCartVendor :: "entity ⇒ bool"
  Vendor :: "entity ⇒ bool"
  Sells :: "entity ⇒ entity ⇒ bool"
  Flower :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"

(* Explanation 1: A flower cart vendor is a vendor who sells flowers on the sidewalk. *)
axiomatization where
  explanation_1: "∀x. FlowerCartVendor x ⟶ (Vendor x ∧ (∃y z. Sells x y ∧ Flower y ∧ Sidewalk z ∧ On y z))"

(* Explanation 2: A vendor who sells flowers is a flower seller. *)
axiomatization where
  explanation_2: "∀x. (Vendor x ∧ (∃y. Sells x y ∧ Flower y)) ⟶ FlowerSeller x"

(* Explanation 3: A flower cart vendor is a flower seller who sells flowers on the sidewalk. *)
axiomatization where
  explanation_3: "∀x. FlowerCartVendor x ⟶ (FlowerSeller x ∧ (∃y z. Sells x y ∧ Flower y ∧ Sidewalk z ∧ On y z))"

theorem hypothesis:
  (* Premise: ∃x. FlowerCartVendor(x) ∧ Sidewalk(x) *)
  assumes asm: "FlowerCartVendor x ∧ Sidewalk x"
  (* Hypothesis: ∃x. FlowerSeller(x) ∧ Sidewalk(x) *)
  shows "∃x. FlowerSeller x ∧ Sidewalk x"
proof -
  from asm have "FlowerCartVendor x" by auto
  then have "Vendor x ∧ (∃y z. Sells x y ∧ Flower y ∧ Sidewalk z ∧ On y z)" using explanation_1 by blast
  then have "FlowerSeller x" using explanation_3 by blast
  show ?thesis using asm by blast
qed

end
