theory question_40_6
imports Main

begin

typedecl entity
typedecl event

consts
  YoungBoy :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  PlayingInWater :: "event ⇒ bool"
  GettingWet :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A young boy is a type of person. *)
axiomatization where
  explanation_1: "∀x. YoungBoy x ⟶ Person x"

(* Explanation 2: Playing in water implies getting wet for any person. *)
axiomatization where
  explanation_2: "∀x e. Person x ∧ PlayingInWater e ⟶ GettingWet e ∧ Agent e x"

(* Explanation 3: Playing in water for a young boy implies the person (who is the young boy) is getting wet. *)
axiomatization where
  explanation_3: "∀x e. YoungBoy x ∧ PlayingInWater e ⟶ GettingWet e ∧ Agent e x"

theorem hypothesis:
  (* Premise: A young boy playing in a bubble playing in water. *)
  assumes asm: "YoungBoy x ∧ Bubble e ∧ PlayingInWater e ∧ Agent e x"
  (* Hypothesis: A person is getting wet. *)
  shows "∃x e. Person x ∧ Wet e ∧ Agent e x"
proof -
  from asm have "PlayingInWater e" by auto
  then have "GettingWet e" using explanation_2 by blast
  then have "Agent e (`Person x`)" using explanation_2 by blast
  from asm have "YoungBoy x" by auto
  then have "`Person x`" using explanation_1 by blast
  show ?thesis using asm `GettingWet e` by blast
qed

end
