theory question_13_0
imports Main

begin

typedecl entity
typedecl event

consts
  Boiling :: "event ⇒ bool"
  Evaporation :: "event ⇒ bool"
  Change :: "event ⇒ bool"
  FromLiquid :: "event ⇒ bool"
  IntoGas :: "event ⇒ bool"
  AddingHeatEnergy :: "event ⇒ bool"
  Heating :: "event ⇒ bool"
  AddingHeat :: "event ⇒ bool"
  Heat :: "entity ⇒ bool"
  HeatEnergy :: "entity ⇒ bool"
  Water :: "entity ⇒ bool"
  Liquid :: "entity ⇒ bool"
  Pan :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Disappears :: "event ⇒ bool"
  Disappeared :: "entity ⇒ bool"
  Gone :: "entity ⇒ bool"
  StateOfMatter :: "entity ⇒ bool"
  Gas :: "entity ⇒ bool"
  Contains :: "entity ⇒ entity ⇒ bool"
  AllGone :: "entity ⇒ bool"
  MatterChangingState :: "event ⇒ bool"
  Example :: "event ⇒ bool"

(* Explanation 1: boiling;evaporation means change from a liquid into a gas by adding heat energy. *)
axiomatization where
  explanation_1: "∀e. Boiling e ∨ Evaporation e ⟷ Change e ∧ FromLiquid e ∧ IntoGas e ∧ AddingHeatEnergy e"

(* Explanation 2: heating means adding heat. *)
axiomatization where
  explanation_2: "∀e. Heating e ⟷ AddingHeat e"

(* Explanation 3: heat means heat energy. *)
axiomatization where
  explanation_3: "∀x. Heat x ⟷ HeatEnergy x"

(* Explanation 4: water is a kind of liquid. *)
axiomatization where
  explanation_4: "∀x. Water x ⟶ Liquid x"

(* Explanation 5: if a liquid disappears then that liquid probably evaporated. *)
axiomatization where
  explanation_5: "∀x e. Liquid x ∧ Disappears e ∧ Agent e x ⟶ Disappeared x ∧ Gas x"

(* Explanation 6: disappeared is similar to gone. *)
axiomatization where
  explanation_6: "∀x. Disappeared x ⟷ Gone x"

(* Explanation 7: liquid is a kind of state of matter. *)
axiomatization where
  explanation_7: "∀x. Liquid x ⟶ StateOfMatter x"

(* Explanation 8: gas is a kind of state of matter. *)
axiomatization where
  explanation_8: "∀x. Gas x ⟶ StateOfMatter x"

theorem hypothesis:
  assumes asm: "Heating e ∧ Pan y ∧ Water z ∧ Agent e x ∧ Patient e y ∧ Contains y z ∧ AllGone z"
  (* Hypothesis: Heating a pan of water until the water is all gone is an example of matter changing state. *)
  shows "∃e x y z. Heating e ∧ Pan y ∧ Water z ∧ Agent e x ∧ Patient e y ∧ Contains y z ∧ AllGone z ∧ MatterChangingState e ∧ Example e"
proof -
  {
    assume asm: "Heating e ∧ Pan y ∧ Water z ∧ Agent e x ∧ Patient e y ∧ Contains y z ∧ AllGone z"
    from asm have "Heating e" by simp
    also from asm have "AddingHeat e" using explanation_2 by blast
    also have "AddingHeatEnergy e" using explanation_3 by blast
    also from asm have "Water z" by simp
    also from asm have "Liquid z" using explanation_4 by blast
    also from asm have "Disappears e" and "Agent e z" using AllGone_def by blast
    also have "Disappeared z" and "Gas z" using explanation_5 by blast
    also from asm have "StateOfMatter z" using explanation_8 by blast
    finally have "Change e ∧ FromLiquid e ∧ IntoGas e" using explanation_1 by blast
  }
  then obtain e' where e': "MatterChangingState e'" using Change_def by blast
  then have "MatterChangingState e" using e' by blast
  also from asm have "Example e" using Example_def by blast
  finally show ?thesis using asm by blast
qed

end
