theory question_85_10
imports Main

begin

typedecl entity
typedecl location

consts
  PacinianCorpuscles :: "entity ⇒ bool"
  SpecificTypeOf :: "entity ⇒ entity ⇒ bool"
  PressureReceptors :: "entity ⇒ bool"
  SharesAllLocationProperties :: "entity ⇒ entity ⇒ bool"
  MainlyFoundIn :: "entity ⇒ location ⇒ bool"
  Skin :: "location"
  FoundIn :: "entity ⇒ location ⇒ bool"

(* Explanation 1: Pacinian corpuscles are a specific type of pressure receptors. *)
axiomatization where
  explanation_1: "∀x. PacinianCorpuscles x ⟶ (∃y. SpecificTypeOf x y ∧ PressureReceptors y)"

(* Explanation 2: If an entity is a specific type of another entity, it shares all the location properties with that entity. *)
axiomatization where
  explanation_2: "∀x y. SpecificTypeOf x y ⟶ SharesAllLocationProperties x y"

(* Explanation 3: Pressure receptors are mainly found in the skin. *)
axiomatization where
  explanation_3: "∀x. PressureReceptors x ⟶ MainlyFoundIn x Skin"

(* Explanation 4: If two entities share all the location properties, then they are mainly found in the same locations as each other. *)
axiomatization where
  explanation_4: "∀x y. SharesAllLocationProperties x y ⟶ (MainlyFoundIn x z ⟷ MainlyFoundIn y z)"

(* Explanation 5: If an entity is mainly found in a location, then that location is a place where the entity is found. *)
axiomatization where
  explanation_5: "∀x y. MainlyFoundIn x y ⟶ FoundIn x y"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "MainlyFoundIn x Skin"
proof -
  from asm have "PacinianCorpuscles x" by simp
  then obtain y where e1: "SpecificTypeOf x y ∧ PressureReceptors y" using explanation_1 by blast
  then have "SharesAllLocationProperties x y" using explanation_2 by blast
  then have "MainlyFoundIn y Skin" using explanation_3 e1 by blast
  then have "MainlyFoundIn x Skin" using explanation_4 by blast
  then have "FoundIn x Skin" using explanation_5 by blast
  show ?thesis using asm by blast
qed

end
