theory question_67_2

imports Main

begin
typedecl entity
typedecl event

consts
  TwoMales :: "entity ⇒ entity ⇒ bool"
  BoatTour :: "entity ⇒ bool"
  RiverBoatTour :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  SittingTogether :: "entity ⇒ entity ⇒ bool"
  OlderMale :: "entity ⇒ bool"
  Male :: "entity ⇒ bool"

(* Explanation 1: In order to take a boat tour, the two males must be on a boat and sitting together. *)
axiomatization where
  explanation_1: "∀x y z. TwoMales x y ∧ BoatTour z ⟶ (On x z ∧ On y z) ∧ SittingTogether x y"

(* Explanation 2: An older male is a male. *)
axiomatization where
  explanation_2: "∀x. OlderMale x ⟶ Male x"

theorem hypothesis:
  (* Premise: Two older males sitting together on a river boat tour. *)
  assumes asm: "OlderMale x ∧ OlderMale y ∧ x ≠ y ∧ RiverBoatTour z ∧ SittingTogether x y ∧ On x z ∧ On y z"
  (* Hypothesis: Two males sitting together on a boat *)
  shows "∃x y z. Male x ∧ Male y ∧ x ≠ y ∧ Boat z ∧ SittingTogether x y ∧ On x z ∧ On y z"
proof -
  from asm have "OlderMale x ∧ OlderMale y ∧ x ≠ y" by blast
  then have "Male x ∧ Male y ∧ x ≠ y" using explanation_2 by blast
  from asm have "RiverBoatTour z ∧ SittingTogether x y ∧ On x z ∧ On y z" by blast
  then have "Boat z ∧ SittingTogether x y ∧ On x z ∧ On y z" by blast
  then show ?thesis using `Male x` `Male y` `x ≠ y` `Boat z` `SittingTogether x y` `On x z` `On y z` by blast
qed

end
