theory question_65_7

imports Main

begin

typedecl entity
typedecl event

consts
  ElectricityFlows :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  On :: "entity ⇒ bool"
  ComesOn :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: When electricity flows to a light bulb, the light comes on. *)
axiomatization where
  explanation_1: "∀x y z e. ElectricityFlows x ∧ LightBulb y ∧ On z ⟶ ComesOn e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: When a switch in a simple series circuit is closed, electricity flows through the circuit. *)
axiomatization where
  explanation_2: "∀x y z e. SwitchClosed(x) ∧ SimpleSeriesCircuit(y) ∧ ElectricityFlows(z) ⟶ FlowsThrough(e) ∧ Agent(e, x) ∧ Patient(e, y)"

(* Premise: When the switch in a simple series circuit is closed. *)
assumes asm: "SwitchClosed x  ∧ SimpleSeriesCircuit y  ∧ Closes e  ∧ Agent e  x  ∧ Patient e  y "

(* Hypothesis: When electricity flows to a light bulb, the light comes on. *)
shows "∃x y z e. ElectricityFlows x ∧ LightBulb y ∧ On z ∧ ComesOn e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "SwitchClosed x ∧ SimpleSeriesCircuit y ∧ Closes e ∧ Agent e x ∧ Patient e y" by simp
  then obtain z where z: "ElectricityFlows z ∧ LightBulb y ∧ On z" using explanation_1 by blast
  have conclusion: "ElectricityFlows z ∧ LightBulb y ∧ On z" using z by simp
  show ?thesis using asm conclusion `ElectricityFlows z` `LightBulb y` `On z` by blast
qed

end
