theory question_65_0

imports Main

begin

typedecl entity
typedecl event

consts
  SwitchClosed :: "event ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Flows :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: When a switch in a simple series circuit is closed, electricity will flow through the circuit. *)
axiomatization where
  explanation_1: "∀x y e. SwitchClosed(e) ∧ SimpleSeriesCircuit(y) ∧ Flows(x) ⟶ Agent(e, x) ∧ Patient(e, y)"

(* Explanation 2: When electricity flows to a light bulb, the light comes on. *)
axiomatization where
  explanation_2: "∀x y e. ElectricityFlows(e) ∧ LightBulb(y) ∧ On(x) ⟶ Agent(e, x) ∧ Patient(e, y)"

(* Premise: When the switch in a simple series circuit is closed. *)
assumes asm: "Switch x  ∧ SimpleSeriesCircuit y  ∧ Closes e  ∧ Agent e  x  ∧ Patient e  y "

(* Hypothesis: When electricity flows to a light bulb, the light comes on. *)
shows "∃x y e. ElectricityFlows e  ∧ LightBulb y  ∧ On x  ∧ Agent e  x  ∧ Patient e  y "
proof -
  from asm have "Switch x ∧ SimpleSeriesCircuit y ∧ Closes e ∧ Agent e x ∧ Patient e y" by simp
  then obtain e1 where e1: "ElectricityFlows e1 ∧ LightBulb y ∧ On x ∧ Agent e1 x ∧ Patient e1 y" using explanation_2 by blast
  have conclusion: "Agent e1 x ∧ Patient e1 y" using e1 by simp
  show ?thesis using asm conclusion `ElectricityFlows e1` by blast
qed

end
