theory question_63_0

imports Main

begin

typedecl entity
typedecl event

consts
  SedimentaryRocks :: "entity ⇒ bool"
  Deposition :: "event ⇒ bool"
  Formed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Sandstone :: "entity ⇒ bool"

(* Explanation 1: Sedimentary rocks are formed by deposition *)
axiomatization where
  explanation_1: "∀x y e. SedimentaryRocks x ∧ Deposition y ∧ Formed e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: Sedimentary Rocks One of the commonest sedimentary rocks is sandstone *)
axiomatization where
  explanation_2: "∀x. SedimentaryRocks x ⟶ Sandstone x"  

theorem hypothesis:
  assumes asm: "SedimentaryRocks x ∧ Deposition y ∧ Formed e"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "∃x y e. SedimentaryRocks x ∧ Deposition y ∧ Formed e ∧ Agent e x ∧ Patient e y ∧ Sandstone e"
proof -
  from asm have "SedimentaryRocks x ∧ Deposition y ∧ Formed e" by simp
  then obtain e1 where e1: "Agent e1 x ∧ Patient e1 y" using explanation_1 by blast
  then have "Sandstone e" using explanation_2 by blast
  have conclusion: "Agent e1 x ∧ Patient e1 y ∧ Sandstone e" using e1 by simp
  show ?thesis using asm conclusion `Sandstone e` by blast
qed

end
