theory question_4_0

imports Main

begin

typedecl entity
typedecl event

consts
  Amphibians :: "entity ⇒ bool"
  Tetrapods :: "entity ⇒ bool"
  FourLimbs :: "entity ⇒ bool"
  Ancathostega :: "entity ⇒ bool"
  Complete :: "entity ⇒ bool"

(* Explanation 1: Amphibians are the first true tetrapods, or vertebrates with four limbs. *)
axiomatization where
  explanation_1: "∀x. Amphibians x ∧ Tetrapods x ∧ FourLimbs x"

(* Explanation 2: Ancathostega is one of the earliest tetrapods found, and by far the most complete. *)
axiomatization where
  explanation_2: "∀x. Ancathostega x ∧ Tetrapods x ∧ Complete x"

theorem hypothesis:
  assumes asm: "Ancathostega x"
  (* Hypothesis: Ancathostega have four limbs. *)
  shows "∃x. FourLimbs x ∧ Ancathostega x"
proof -
  from asm have "Ancathostega x" by simp
  then obtain e1 where e1: "Tetrapods x ∧ FourLimbs x" using explanation_1 by blast
  then have "Tetrapods x" using e1 by simp
  then have "FourLimbs x" using e1 by simp
  show ?thesis using asm `Tetrapods x` `FourLimbs x` by blast
qed

end
