theory question_21_4

imports Main

begin

typedecl entity
typedecl event

consts
  Birds :: "entity ⇒ bool"
  ClassAves :: "entity ⇒ bool"
  EndothermicTetrapodVertebrate :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 2: Birds are a type of animal in Class Aves, and all birds are endothermic tetrapod vertebrates. *)
axiomatization where
  explanation_2: "∀x y. Birds x ∧ ClassAves y ∧ EndothermicTetrapodVertebrate x ∧ Agent x y"

theorem hypothesis:
  assumes asm: "EndothermicTetrapodVertebrate x"
  (* Hypothesis: An endothermic tetrapod vertebrate would be animals in the class aves. *)
  shows "∃y. ClassAves y ∧ Agent x y"
proof -
  from asm have "EndothermicTetrapodVertebrate x" by simp
  then obtain e1 where e1: "Agent x y ∧ ClassAves y" using explanation_2 by blast
  then have "ClassAves y" using e1 by simp
  show ?thesis using asm classAves by blast
qed

end
