theory question_67_9

imports Main

begin

typedecl entity
typedecl event
consts
 Male :: "entity ⇒ bool"
 Older :: "entity ⇒ bool"
 Participant :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Tour :: "entity ⇒ bool"
 MeansOfTransportation :: "entity ⇒ bool"
 Boat :: "entity ⇒ bool"
 Exists :: "entity ⇒ bool"
 On :: "entity ⇒ entity ⇒ bool"
 Duration :: "event ⇒ bool"
 Present :: "event ⇒ bool"
 Route :: "entity ⇒ bool"
 Follows :: "event ⇒ bool"
 Guide :: "event ⇒ entity ⇒ bool"
 Person :: "entity ⇒ bool"
 GroupOfPeople :: "entity ⇒ bool"
 Start :: "event ⇒ entity ⇒ bool"
 End :: "event ⇒ entity ⇒ bool"
 Location :: "entity ⇒ bool"
 Sit :: "event ⇒ bool"

(* Premise: Two older males sitting together on a boat. *)
assumes asm: "Male x  ∧ Male y  ∧ Sit e  ∧ Agent e  x  ∧ Agent e  y "

(* Hypothesis: A river boat tour is a means of transportation for the two older males. *)
shows "∃x y e. RiverBoatTour x  ∧ MeansOfTransportation x  ∧ Agent e  y "
proof -
 from asm have "Male x ∧ Male y ∧ Sit e ∧ Agent e x ∧ Agent e y" by blast
 then have "Person x ∧ Person y ∧ On x y ∧ Duration e ∧ Present e" using explanation_1 by blast
 then have "RiverBoatTour x ∧ MeansOfTransportation x ∧ Agent e y" using explanation_2 by blast
 then show ?thesis using `Person x` `Person y` `On x y` `Duration e` `Present e` `RiverBoatTour x` `MeansOfTransportation x` `Agent e y` by blast
qed

end
