theory question_93_2

imports Main

begin

typedecl entity

consts
  AdultEchinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Echinoderms :: "entity ⇒ bool"
  AdultStarfish :: "entity ⇒ bool"

(* Explanation 1: Adult echinoderms have radial symmetry. *)
axiomatization where
  explanation_1: "∀x. AdultEchinoderms x ⟶ RadialSymmetry x"

(* Explanation 2: Starfish are a type of echinoderms. *)
axiomatization where
  explanation_2: "∀x. Starfish x ⟶ Echinoderms x"  

(* Explanation 3: Adult starfish are a type of adult echinoderms. *)
axiomatization where
  explanation_3: "∀x. AdultStarfish x ⟶ AdultEchinoderms x"  

theorem hypothesis:
  assumes asm: "AdultStarfish x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "RadialSymmetry x"
proof -
  from asm have "AdultStarfish x" by simp
  then have "AdultEchinoderms x" using explanation_3 by blast
  then have "RadialSymmetry x" using explanation_1 by blast
  show ?thesis using `RadialSymmetry x` by blast
qed

end
