theory question_91_5
imports Main

begin

typedecl entity
typedecl event

consts
  Bears :: "entity ⇒ bool"
  Animals :: "entity ⇒ bool"
  Hibernate :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Energy :: "entity ⇒ bool"
  Conserve :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Bears are animals that hibernate. *)
axiomatization where
  explanation_1: "∀x e. Bears x ⟶ (Animals x ∧ Hibernate e ∧ Agent e x)"

(* Explanation 2: The purpose of hibernation in bears is to conserve energy. *)
axiomatization where
  explanation_2: "∀x y e. Bears x ∧ Energy y ∧ Hibernate e ∧ Agent e x ⟶ Conserve e y"  

theorem hypothesis:
  assumes asm: "Bears x ∧ Energy y"
  (* Hypothesis: Bears hibernate to conserve energy. *)
  shows "∃x y e1 e2. Bears x ∧ Energy y ∧  Hibernate e1 ∧ Agent e1 x  ∧  Conserve e2 y ∧ Agent e2 x ∧ Patient e2 y "
proof -
  from asm have "Bears x ∧ Energy y" by simp
  then obtain e1 where e1: "Hibernate e1 ∧ Agent e1 x" using explanation_1 by blast
  then have "Conserve e2 y ∧ Agent e2 x ∧ Patient e2 y" using explanation_2 by blast
  have conclusion: "Hibernate e1 ∧ Agent e1 x" using e1 by simp
  show ?thesis using asm conclusion `Conserve e2 y` `Agent e2 x` `Patient e2 y` by blast
qed

end
