theory question_30_1

imports Main

begin
typedecl entity
typedecl event

consts
  Tricks :: "entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Inferred :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Human :: "entity ⇒ bool"
  Doing :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Tricks on a skateboard is inferred as doing tricks. *)
axiomatization where
  explanation_1: "∀x y e. Tricks x ∧ Skateboard y ∧ On x y ⟶ Inferred e ∧ Agent e x"

(* Explanation 2: A man is a human. *)
axiomatization where
  explanation_2: "∀x. Man x ⟶ Human x"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Tricks y ∧ Skateboard z ∧ Doing e ∧ Agent e x ∧ Patient e y ∧ On y z"
  (* Hypothesis: A human doing tricks *)
  shows "∃x e. Human x ∧ Doing e ∧ Agent e x"
proof -
  from asm have "Man x ∧ Doing e ∧ Agent e x" by blast
  then have "Human x ∧ Doing e ∧ Agent e x" using explanation_2 by blast
  show ?thesis using `Human x` `Doing e` `Agent e x` by blast
qed

end
