theory question_65_0
imports Main

begin

typedecl entity
typedecl event

consts
  Electricity :: "entity ⇒ bool"
  Flows :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  ComeOn :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Closed :: "event ⇒ bool"
  Flow :: "event ⇒ bool"
  Through :: "event ⇒ bool"
  Circuit :: "entity ⇒ bool"

(* Explanation 1: When electricity flows to a light bulb, the light bulb will turn on; come on. *)
axiomatization where
  explanation_1: "∀e x y. Electricity x ∧ Flows e ∧ LightBulb y ∧ TurnOn e ∧ ComeOn e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: When a switch in a simple series circuit is closed, electricity will flow through the circuit. *)
axiomatization where
  explanation_2: "∀e x y. Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Flow e ∧ Through e ∧ Circuit y ∧ Agent e x"

theorem hypothesis:
  (* Premise: When the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Agent e x"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃e x y. Electricity e ∧ Flows e ∧ LightBulb x ∧ ComeOn e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Electricity e" and "SimpleSeriesCircuit y" using explanation_2 by blast+
  then have "Flows e" using explanation_2 by blast
  then obtain x where x: "LightBulb x ∧ TurnOn e ∧ ComeOn e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  have conclusion: "TurnOn e ∧ ComeOn e ∧ Agent e x ∧ Patient e y" using x by simp
  show ?thesis using conclusion `Electricity e` `Flows e` by blast
qed

end
