theory question_81_0

imports Main

begin

typedecl entity
typedecl event

consts
  BottleneckEffect :: "entity ⇒ bool"
  Population :: "entity ⇒ bool"
  SuddenlyMuchSmaller :: "entity ⇒ bool"
  Occurs :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  ExternalMigration :: "entity ⇒ bool"
  PopulationGrowth :: "entity ⇒ bool"
  Reduced :: "event ⇒ bool"

(* Explanation 1: Bottleneck effect occurs when a population suddenly gets much smaller. *)
axiomatization where
  explanation_1: "∀e x y. BottleneckEffect x ∧ Population y ∧ SuddenlyMuchSmaller z ∧ Occurs e ∧ Agent e x ∧ Patient e y ∧ Patient e z"

(* Explanation 2: Population growth is reduced by external migration. *)
axiomatization where
  explanation_2: "∀e x y. PopulationGrowth x ∧ ExternalMigration y ∧ Reduced e ∧ Agent e y ∧ Patient e x"

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e x y. BottleneckEffect x ∧ ExternalMigration y ∧ Occurs e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "BottleneckEffect x ∧ ExternalMigration y" by simp
  then obtain z e where z_e: "Population z ∧ SuddenlyMuchSmaller z ∧ Occurs e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then have "Occurs e ∧ Agent e x ∧ Patient e y" using z_e by blast
  then obtain e' where e': "Reduced e' ∧ Agent e' y ∧ Patient e' x" using explanation_2 by blast
  have conclusion: "Occurs e ∧ Agent e x ∧ Patient e y" using `Occurs e ∧ Agent e x ∧ Patient e y` by simp
  show ?thesis using asm conclusion `ExternalMigration y` by blast
qed

end
