theory question_20_0
imports Main

begin

typedecl entity
typedecl event

consts
  Hair :: "entity ⇒ bool"
  Fiber :: "entity ⇒ bool"
  Mammals :: "entity ⇒ bool"
  FoundIn :: "entity ⇒ entity ⇒ bool"
  Fur :: "entity ⇒ bool"
  Have :: "event ⇒ entity ⇒ bool"
  Unique :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Hair is a fiber that is found only in mammals. *)
axiomatization where
  explanation_1: "∀x. Hair x ⟶ Fiber x ∧ (∃y. Mammals y ∧ FoundIn x y)"

(* Explanation 2: All mammals have fur or hair. *)
axiomatization where
  explanation_2: "∀x. Mammals x ⟶ (∃e1 e2 y. Fur e1 ∧ Hair e2 ∧ ((Have e1 x) ∨ (Have e2 x)))"

theorem hypothesis:
  assumes asm: "Hair x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "∃x. Fur x ∧ Mammals y ∧ Unique x y"
proof -
  from asm have "Hair x" by simp
  then obtain y where y: "Mammals y ∧ FoundIn x y" using explanation_1 by blast
  then obtain e1 e2 where e1_e2: "Fur e1 ∧ Hair e2 ∧ ((Have e1 y) ∨ (Have e2 y))" using explanation_2 y by blast
  have conclusion: "Mammals y ∧ FoundIn x y ∧ Fur e1 ∧ Hair e2 ∧ ((Have e1 y) ∨ (Have e2 y))" using y e1_e2 by simp
  show ?thesis using conclusion by blast
qed

end
