theory question_12_3
imports Main

begin

typedecl entity
typedecl event

consts
  Biofuel :: "entity ⇒ bool"
  Ethanol :: "entity ⇒ bool"
  Burning :: "entity ⇒ bool"
  ProduceElectricity :: "entity ⇒ bool"
  SubsetOf :: "entity ⇒ bool"
  UsedInProduction :: "entity ⇒ bool"
  Electricity :: "event ⇒ bool"

(* Explanation 1: Burning biofuel, specifically ethanol, is a method used to produce electricity. *)
axiomatization where
  explanation_1: "∀e. Biofuel e ∧ Ethanol e ∧ Burning e ∧ ProduceElectricity e"

(* Explanation 2: Burning ethanol, as a subset of biofuel, is specifically used in the production of electricity. *)
axiomatization where
  explanation_2: "∀e. Ethanol e ∧ Biofuel e ∧ SubsetOf e ∧ UsedInProduction e ∧ Electricity e"

theorem hypothesis:
  assumes asm: "Burning x"
  (* Hypothesis: Burning ethanol is used to produce electricity. *)
  shows "∃e. Burning x ∧ ProduceElectricity e"
proof -
  from asm have "Burning x" by simp
  then obtain e where e: "ProduceElectricity e" using explanation_1 by blast
  then have "Burning x ∧ ProduceElectricity e" using `Burning x` e by simp
  then show ?thesis using asm by blast
qed

end
