theory question_67_1
imports Main

begin
typedecl entity
typedecl event

consts
  BoatTour :: "entity ⇒ bool"
  Boat :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Male :: "entity ⇒ bool"
  Older :: "entity ⇒ bool"
  River :: "entity ⇒ bool"
  Sitting :: "entity ⇒ bool"
  Together :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: In order to take a boat tour, it is essential to be on a boat. *)
axiomatization where
  explanation_1: "∀x. BoatTour x ⟶ (∃e. Boat e ∧ On x e)"

(* Explanation 2: Being on a boat is a prerequisite for a boat tour. *)
axiomatization where
  explanation_2: "∀x. BoatTour x ⟶ (∃e. Boat e ∧ On x e)"


theorem hypothesis:
  (* Premise: Two older males sitting together on a river boat tour. *)
  assumes asm: "Male x ∧ Male y ∧ Older x ∧ Older y ∧ River e ∧ BoatTour e ∧ Sitting e ∧ Together x y"
  (* Hypothesis: Two males sitting together on a boat. *)
  shows "∃x y e. Male x ∧ Male y ∧ Boat e ∧ Sitting e ∧ Together x y ∧ On x e ∧ On y e"
proof -
  from asm have "River e ∧ BoatTour e ∧ Sitting e ∧ Together x y" by blast
  then obtain e where "Boat e ∧ On e x" using explanation_1 by blast
  then have "Boat e ∧ On e x ∧ On e y" using `Together x y` by blast
  then show ?thesis using asm by blast
qed

end
