import sys

def merge_files(file_src, file_tgt, sep_token, file_out):
    f_out = open(file_out, 'w', encoding='utf8')

    with open(file_src, 'r', encoding='utf8') as f_s, open(file_tgt, 'r', encoding='utf8') as f_t:
        for line_id, (line_s, line_t) in enumerate(zip(f_s, f_t)):
            line_s, line_t = line_s.strip(), line_t.strip()
            out_line = line_s + ' ' + sep_token + ' ' +line_t
            f_out.write(out_line + '\n')

    f_out.close()

if __name__ == '__main__':
    files = sys.argv[:-2]
    src_file, tgt_file, sep_token, file_out = sys.argv[1:]
    merge_files(src_file, tgt_file, sep_token, file_out)
