LANGUAGE=$1
LANGUAGE_ID=$2
# TRAIN
python aligner.py --inp1 ../models/${LANGUAGE}/mbart/vanilla-data/train.en_XX  --inp2 ../models/${LANGUAGE}/mbart/vanilla-data/train.${LANGUAGE_ID}  --output_file ../models/${LANGUAGE}/mbart/consistent-data/train.input --alignment_type translation_sentence --lang ${LANGUAGE} --model_name_or_path ../models/${LANGUAGE}/model_without_co/ 
cp ../models/${LANGUAGE}/mbart/vanilla-data/train.${LANGUAGE_ID} ../models/${LANGUAGE}/mbart/consistent-data/train.${LANGUAGE_ID}

# VALID
python aligner.py --inp1 ../models/${LANGUAGE}/mbart/vanilla-data/valid.en_XX  --inp2 ../models/${LANGUAGE}/mbart/vanilla-data/valid.${LANGUAGE_ID}   --output_file ../models/${LANGUAGE}/mbart/consistent-data/valid.input --alignment_type translation_sentence --lang ${LANGUAGE} --model_name_or_path ../models/${LANGUAGE}/model_without_co/ 
cp ../models/${LANGUAGE}/mbart/vanilla-data/valid.${LANGUAGE_ID} ../models/${LANGUAGE}/mbart/consistent-data/valid.${LANGUAGE_ID}

# # SENTENCES
python aligner.py --inp1 ../data/en/train.sentences --inp2 ../data/${LANGUAGE}/mbart/train.sentences --output_file ../data/${LANGUAGE}/mbart/consistent/word_aligned.sentences --alignment_type translation_sentence --lang ${LANGUAGE} --model_name_or_path ../models/${LANGUAGE}/model_without_co/

# # EXTRACTIONS
python aligner.py --inp1 ../data/openie6/train.sentences_labels_aux  --inp2 ../data/${LANGUAGE}/mbart/train.sentences_repeated  --output_file ../data/${LANGUAGE}/mbart/consistent/word_aligned.extractions --alignment_type translation_extraction --lang ${LANGUAGE} --model_name_or_path ../models/${LANGUAGE}/model_without_co/

