## Code of our paper "Enhancing Cross-lingual Natural Language Inference by Prompt-learning from Cross-lingual Templates"

## Prerequisites

 * Python 3.7
 * tensorflow==2.4.0
 * keras_bert==0.88.0
 * transformers==4.12.3
 * sentencepiece==0.1.96


### Datasets
We use XNLI and PAWS-X in our experiments.

| Datasets           | Download Links                                                       |
|--------------------|----------------------------------------------------------------------|
| XNLI               | https://cims.nyu.edu/~sbowman/xnli/                                  |
| XNLI (fewshot)     | https://github.com/mprompting/xlmrprompt                             |
| PAWS-X             | https://github.com/google-research-datasets/paws/tree/master/pawsx   |

Put the datasets into the [PCT/datasets/]().

## Use examples
We can run our models on the google [colab platform](https://colab.research.google.com/).

1. Install requirements:

``! pip install keras_bert transformers sentencepiece tensorflow==2.4.0``

2. Train model on TPUs:

``! python drive/PCT/train_xnli.py``

3. Evaluate model on TPUs:

``! python drive/PCT/predict_xnli.py``


