import argparse


def main(args):
    with open(args.input, 'rt') as fpr, \
            open(args.output, 'wt') as fwp:
        count = 0
        remove_count = 0
        for line in fpr:
            line = line.strip()
            if not line:
                continue
            count += 1
            cols = line.split("\t")
            try:
                if any(ts.split("|")[1] != "other" for ts in cols[2].split()):
                    fwp.write(line + "\n")
                else:
                    remove_count += 1
            except KeyError:
                raise ValueError("The following line is not well formatted\n'{}'".format(line))
        print("{} lines removed out of {} lines.".format(remove_count, count))


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description='Remove utterances with no slots from a TSV file.')
    parser.add_argument('input', type=str, help='Input TSV files')
    parser.add_argument('output', type=str, help='Output TSV files')
    args = parser.parse_args()
    main(args)
