/*
 * Decompiled with CFR 0.152.
 */
package annotation_scorers;

import annotation_scorers.Judgement;
import annotation_scorers.Score;
import java.util.ArrayList;
import java.util.HashMap;

public class Scomp {
    public HashMap<String, ArrayList<Judgement>> corr_increase = new HashMap();
    public HashMap<String, ArrayList<Judgement>> spur_decrease = new HashMap();
    public HashMap<String, ArrayList<Judgement>> corr_decrease = new HashMap();
    public HashMap<String, ArrayList<Judgement>> spur_increase = new HashMap();
    private HashMap<String, Double> p_imp = new HashMap();
    private HashMap<String, Double> r_imp = new HashMap();
    private HashMap<String, Double> f_imp = new HashMap();
    private HashMap<String, Double> p_imp_TokLevel = new HashMap();
    private HashMap<String, Double> r_imp_TokLevel = new HashMap();
    private HashMap<String, Double> f_imp_TokLevel = new HashMap();
    private HashMap<String, Double> p_erred = new HashMap();
    private HashMap<String, Double> r_erred = new HashMap();
    private HashMap<String, Double> f_erred = new HashMap();
    private HashMap<String, Double> p_erred_TokLevel = new HashMap();
    private HashMap<String, Double> r_erred_TokLevel = new HashMap();
    private HashMap<String, Double> f_erred_TokLevel = new HashMap();

    public Scomp(Score improved, Score base) {
        for (String e : improved.getJudgements().keySet()) {
            this.p_imp.put(e, this.improvement(Score.oneDecPos(improved.getPrecision(e)), Score.oneDecPos(base.getPrecision(e))));
            this.r_imp.put(e, this.improvement(Score.oneDecPos(improved.getRecall(e)), Score.oneDecPos(base.getRecall(e))));
            this.f_imp.put(e, this.improvement(Score.oneDecPos(improved.getF1(e)), Score.oneDecPos(base.getF1(e))));
            this.p_imp_TokLevel.put(e, this.improvement(Score.twoDecPos(improved.getPrecisionTokenLevel(e)), Score.twoDecPos(base.getPrecisionTokenLevel(e))));
            this.r_imp_TokLevel.put(e, this.improvement(Score.twoDecPos(improved.getRecallTokenLevel(e)), Score.twoDecPos(base.getRecallTokenLevel(e))));
            this.f_imp_TokLevel.put(e, this.improvement(Score.twoDecPos(improved.getF1TokenLevel(e)), Score.twoDecPos(base.getF1TokenLevel(e))));
            this.p_erred.put(e, this.err_reduction(Score.oneDecPos(improved.getPrecision(e)), Score.oneDecPos(base.getPrecision(e))));
            this.r_erred.put(e, this.err_reduction(Score.oneDecPos(improved.getRecall(e)), Score.oneDecPos(base.getRecall(e))));
            this.f_erred.put(e, this.err_reduction(Score.oneDecPos(improved.getF1(e)), Score.oneDecPos(base.getF1(e))));
            this.p_erred_TokLevel.put(e, this.err_reduction(Score.twoDecPos(improved.getPrecisionTokenLevel(e)) * 100.0, Score.twoDecPos(base.getPrecisionTokenLevel(e)) * 100.0));
            this.r_erred_TokLevel.put(e, this.err_reduction(Score.twoDecPos(improved.getRecallTokenLevel(e)) * 100.0, Score.twoDecPos(base.getRecallTokenLevel(e)) * 100.0));
            this.f_erred_TokLevel.put(e, this.err_reduction(Score.twoDecPos(improved.getF1TokenLevel(e)) * 100.0, Score.twoDecPos(base.getF1TokenLevel(e)) * 100.0));
            this.corr_increase.put(e, new ArrayList());
            this.spur_decrease.put(e, new ArrayList());
            this.corr_decrease.put(e, new ArrayList());
            this.spur_increase.put(e, new ArrayList());
            ArrayList<Judgement> improved_judgements = improved.getJudgements().get(e);
            ArrayList<Judgement> base_judgements = base.getJudgements().get(e);
            Judgement ji = null;
            Judgement jb = null;
            while (improved_judgements.size() > 0 || base_judgements.size() > 0) {
                if (ji == null && improved_judgements.size() > 0) {
                    ji = improved_judgements.get(0);
                    improved_judgements.remove(0);
                }
                if (jb == null && base_judgements.size() > 0) {
                    jb = base_judgements.get(0);
                    base_judgements.remove(0);
                }
                if (jb != null && ji != null && ji.getNumline() == jb.getNumline()) {
                    if (ji.getJudgement_int() != jb.getJudgement_int()) {
                        if (ji.getJudgement_str().equals("corr")) {
                            this.corr_increase.get(e).add(jb);
                        }
                        if (jb.getJudgement_str().equals("corr")) {
                            this.corr_decrease.get(e).add(ji);
                        }
                    }
                    ji = null;
                    jb = null;
                    continue;
                }
                if (jb == null || ji != null && ji.getNumline() < jb.getNumline()) {
                    if (!ji.getJudgement_str().equals("spur")) {
                        System.err.println("\n\nSpur EXPECTED (found " + ji.getJudgement_str() + ") approach, line " + ji.getNumline());
                        System.err.println(ji.getNumline());
                        System.err.println(">>corr>>\n" + ji.getKeylines());
                        System.err.println("<<annot<<\n" + ji.getAnnotlines() + "\n");
                        if (jb != null) {
                            System.err.println("baseline: " + jb.getNumline());
                            System.err.println(">>corr>>\n" + jb.getKeylines());
                            System.err.println("<<annot<<\n" + jb.getAnnotlines() + "\n");
                        }
                        System.err.println("------ERROR------");
                        System.exit(0);
                    }
                    this.spur_increase.get(e).add(ji);
                    ji = null;
                    continue;
                }
                if (!jb.getJudgement_str().equals("spur")) {
                    System.err.println("\n\nSpur EXPECTED (found " + jb.getJudgement_str() + ") approach, line " + jb.getNumline());
                    System.err.println(jb.getNumline());
                    System.err.println(">>corr>>\n" + jb.getKeylines());
                    System.err.println("<<annot<<\n" + jb.getAnnotlines() + "\n");
                    if (ji != null) {
                        System.err.println("baseline: " + ji.getNumline());
                        System.err.println(">>corr>>\n" + ji.getKeylines());
                        System.err.println("<<annot<<\n" + ji.getAnnotlines() + "\n");
                    }
                    System.err.println("------ERROR2------");
                    System.exit(0);
                }
                this.spur_decrease.get(e).add(jb);
                jb = null;
            }
        }
    }

    public Double improvement(double improved, double base) {
        return improved * 100.0 / base - 100.0;
    }

    public Double err_reduction(double improved, double base) {
        return (100.0 - base - (100.0 - improved)) / (100.0 - base) * 100.0;
    }

    public void print() {
        System.out.println("Print comparative\n\n");
        for (String e : this.p_imp.keySet()) {
            System.out.println(">" + e.toUpperCase());
            System.out.println("\t REGULAR IMPROVEMENT \tPrecision=" + Score.oneDecPos(this.p_imp.get(e)) + " (err_reduct " + Score.oneDecPos(this.p_erred.get(e)) + ") %\tRecall=" + Score.oneDecPos(this.r_imp.get(e)) + " (err_reduct " + Score.oneDecPos(this.r_erred.get(e)) + ") %\tF1=" + Score.oneDecPos(this.f_imp.get(e)) + " (err_reduct " + Score.oneDecPos(this.f_erred.get(e)) + ") %\t- corr_inc=" + this.corr_increase.get(e).size() + "; spur_dec=" + this.spur_decrease.get(e).size() + " -- corr_dec=" + this.corr_decrease.get(e).size() + "; spur_inc=" + this.spur_increase.get(e).size());
            System.out.println("\t Token level impr\tPrecision=" + Score.oneDecPos(this.p_imp_TokLevel.get(e)) + " (err_reduct " + Score.oneDecPos(this.p_erred_TokLevel.get(e)) + ") %\tRecall=" + Score.oneDecPos(this.r_imp_TokLevel.get(e)) + " (err_reduct " + Score.oneDecPos(this.r_erred_TokLevel.get(e)) + ") %\tF1=" + Score.oneDecPos(this.f_imp_TokLevel.get(e)) + " (err_reduct " + Score.oneDecPos(this.f_erred_TokLevel.get(e)) + ") %");
            System.out.println("\nCorr increase cases\n");
            for (Judgement j : this.corr_increase.get(e)) {
                System.out.println(">>corr>>\n" + j.getKeylines());
                System.out.println("<<annot<<\n" + j.getAnnotlines() + "\n");
            }
            System.out.println("\nSpur decrease cases\n");
            for (Judgement j : this.spur_decrease.get(e)) {
                System.out.println(j.getAnnotlines() + "\n");
            }
            System.out.println("\nCorr decrease cases\n");
            for (Judgement j : this.corr_decrease.get(e)) {
                System.out.println(">>corr>>\n" + j.getKeylines());
                System.out.println("<<annot<<\n" + j.getAnnotlines() + "\n");
            }
            System.out.println("\nSpur increase cases\n");
            for (Judgement j : this.spur_increase.get(e)) {
                System.out.println(j.getAnnotlines() + "\n");
            }
        }
    }
}

